/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.elasticsearch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.elasticsearch.ElasticsearchSplit;
import io.trino.plugin.elasticsearch.ElasticsearchTableHandle;
import io.trino.plugin.elasticsearch.client.ElasticsearchClient;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ElasticsearchSplitManager
implements ConnectorSplitManager {
    private final ElasticsearchClient client;

    @Inject
    public ElasticsearchSplitManager(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        ElasticsearchTableHandle tableHandle = (ElasticsearchTableHandle)table;
        if (tableHandle.getType().equals((Object)ElasticsearchTableHandle.Type.QUERY)) {
            return new FixedSplitSource((ConnectorSplit)new ElasticsearchSplit(tableHandle.getIndex(), 0, Optional.empty()));
        }
        List splits = (List)this.client.getSearchShards(tableHandle.getIndex()).stream().map(shard -> new ElasticsearchSplit(shard.getIndex(), shard.getId(), shard.getAddress())).collect(ImmutableList.toImmutableList());
        return new FixedSplitSource((Iterable)splits);
    }
}

