/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Suppliers;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.security.AccessControlRules;
import io.trino.plugin.base.security.FileBasedAccessControl;
import io.trino.plugin.base.security.FileBasedAccessControlConfig;
import io.trino.plugin.base.security.ForAccessControlRules;
import io.trino.plugin.base.security.ForwardingConnectorAccessControl;
import io.trino.plugin.base.security.HttpBasedAccessControlRulesProvider;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.connector.ConnectorAccessControl;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class FileBasedAccessControlModule
extends AbstractConfigurationAwareModule {
    private static final Logger log = Logger.get(FileBasedAccessControlModule.class);

    public void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileBasedAccessControlConfig.class);
        this.install(ConditionalModule.conditionalModule(FileBasedAccessControlConfig.class, FileBasedAccessControlConfig::isHttp, (Module)new HttpAccessControlModule(), (Module)new LocalAccessControlModule()));
    }

    @Inject
    @Provides
    @Singleton
    public ConnectorAccessControl getConnectorAccessControl(CatalogName catalogName, FileBasedAccessControlConfig config, Supplier<AccessControlRules> rulesProvider) {
        if (config.getRefreshPeriod() != null) {
            return ForwardingConnectorAccessControl.of((Supplier<ConnectorAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                log.info("Refreshing access control for catalog '%s' from: %s", new Object[]{catalogName, config.getConfigFile()});
                return new FileBasedAccessControl(catalogName, (AccessControlRules)rulesProvider.get());
            }, (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        return new FileBasedAccessControl(catalogName, rulesProvider.get());
    }

    private static class HttpAccessControlModule
    implements Module {
        private HttpAccessControlModule() {
        }

        public void configure(Binder binder) {
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("access-control", ForAccessControlRules.class).withConfigDefaults(config -> config.setRequestTimeout(Duration.succinctDuration((double)10.0, (TimeUnit)TimeUnit.SECONDS)).setSelectorCount(1).setMinThreads(1));
            binder.bind(HttpBasedAccessControlRulesProvider.class).in(Scopes.SINGLETON);
        }

        @Inject
        @Provides
        @Singleton
        public Supplier<AccessControlRules> getAccessControlRules(HttpBasedAccessControlRulesProvider rulesProvider) {
            return () -> rulesProvider.extract(AccessControlRules.class);
        }
    }

    private static class LocalAccessControlModule
    implements Module {
        private LocalAccessControlModule() {
        }

        public void configure(Binder binder) {
        }

        @Inject
        @Provides
        @Singleton
        public Supplier<AccessControlRules> getAccessControlRules(FileBasedAccessControlConfig config) {
            File configFile = new File(config.getConfigFile());
            Supplier<AccessControlRules> accessControlRulesProvider = () -> JsonUtils.parseJson(configFile.toPath(), config.getJsonPointer(), AccessControlRules.class);
            return accessControlRulesProvider;
        }
    }
}

