/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import java.util.function.BiFunction;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.MapNamingFunction;
import org.weakref.jmx.guice.MapObjectNameFunction;
import org.weakref.jmx.guice.NamingFunction;
import org.weakref.jmx.guice.ObjectNameFunction;

public class MapExportBinder<K, V> {
    protected final Multibinder<MapMapping<?, ?>> binder;
    protected final Class<K> keyClass;
    private final Class<V> valueClass;

    MapExportBinder(Multibinder<MapMapping<?, ?>> binder, Class<K> keyClass, Class<V> valueClass) {
        this.binder = binder;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public void withGeneratedName(NamingFunction<V> valueNamingFunction) {
        BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> nameFactory = (factory, entry) -> {
            try {
                String itemName = valueNamingFunction.name(entry.getValue());
                return new ObjectName(factory.generatedNameOf(this.valueClass, itemName));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        };
        this.as(nameFactory);
    }

    public void withGeneratedName(ObjectNameFunction<V> valueNamingFunction) {
        this.as((factory, entry) -> valueNamingFunction.name(entry.getValue()));
    }

    public void withGeneratedName(MapNamingFunction<K, V> valueNamingFunction) {
        BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> nameFactory = (factory, entry) -> {
            try {
                String itemName = valueNamingFunction.name(entry.getKey(), entry.getValue());
                return new ObjectName(factory.generatedNameOf(this.valueClass, itemName));
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        };
        this.as(nameFactory);
    }

    public void withGeneratedName(MapObjectNameFunction<K, V> valueNamingFunction) {
        this.as((factory, entry) -> valueNamingFunction.name(entry.getKey(), entry.getValue()));
    }

    public void as(BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> nameFactory) {
        this.binder.addBinding().toInstance(new MapMapping<K, V>(this.keyClass, this.valueClass, nameFactory));
    }
}

