/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public class JsonSubType {
    private final Set<Module> modules;

    public static Builder builder() {
        return new Builder();
    }

    public Set<Module> modules() {
        return this.modules;
    }

    private JsonSubType(Set<Module> modules) {
        this.modules = modules;
    }

    public static class Builder {
        private final ImmutableSet.Builder<Module> modules = ImmutableSet.builder();

        private Builder() {
        }

        public <B> SubTypeSubBuilder<B> forBase(final Class<B> baseClass, String propertyName) {
            final ImmutableMap.Builder subClassBuilder = ImmutableMap.builder();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ImmutableMap.Builder)subClassBuilder).build());
            TypeAddingModule module = new TypeAddingModule(propertyName, (Supplier<Map<String, Class<?>>>)supplier);
            module.addDeserializer(baseClass, new Deserializer(propertyName, (Supplier<Map<String, Class<?>>>)supplier));
            this.modules.add((Object)module);
            return new SubTypeSubBuilder<B>(){

                @Override
                public <T extends B> SubTypeSubBuilder<B> add(Class<T> subClass, String propertyValue) {
                    subClassBuilder.put((Object)propertyValue, subClass);
                    return this;
                }

                @Override
                public SubTypeSubBuilder<B> addPermittedSubClasses(Function<Class<?>, String> propertyValueProvider) {
                    Arrays.stream(baseClass.getPermittedSubclasses()).forEach(clazz -> this.add((Class)clazz, (String)propertyValueProvider.apply((Class<?>)clazz)));
                    return this;
                }

                @Override
                public <T> SubTypeSubBuilder<T> forBase(Class<T> baseClass2, String propertyName) {
                    return this.forBase(baseClass2, propertyName);
                }

                @Override
                public JsonSubType build() {
                    return new JsonSubType((Set<Module>)modules.build());
                }
            };
        }
    }

    private static class Deserializer<B>
    extends JsonDeserializer<B> {
        private final String propertyName;
        private final Supplier<Map<String, Class<?>>> subClassPropertyValues;

        public Deserializer(String propertyName, Supplier<Map<String, Class<?>>> subClassPropertyValues) {
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName is null");
            this.subClassPropertyValues = subClassPropertyValues;
        }

        public B deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String propertyValue;
            TreeNode treeNode = p.readValueAsTree();
            TreeNode propertyNode = treeNode.get(this.propertyName);
            String string = propertyValue = propertyNode != null && propertyNode.isValueNode() ? ((ValueNode)propertyNode).textValue() : null;
            if (propertyValue == null) {
                throw new IllegalArgumentException("JSON expected to have a property named \"%s\". Double check the addBinding() or addPermittedSubClassBindings()".formatted(this.propertyName));
            }
            Class<?> subClass = this.subClassPropertyValues.get().get(propertyValue);
            if (subClass == null) {
                throw new IllegalArgumentException("No binding was made for property name \"%s\" and value \"%s\". Double check the addBinding() or addPermittedSubClassBindings().".formatted(this.propertyName, propertyValue));
            }
            return (B)p.getCodec().treeToValue(treeNode, subClass);
        }
    }

    private static class TypeAddingIntrospector
    extends AnnotationIntrospector {
        private final String propertyName;
        private final Map<Class<?>, String> subClassPropertyValues;

        private TypeAddingIntrospector(String propertyName, Map<Class<?>, String> subClassPropertyValues) {
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName is null");
            this.subClassPropertyValues = ImmutableMap.copyOf(subClassPropertyValues);
        }

        public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
            final String propertyValue = this.subClassPropertyValues.get(ac.getRawType());
            if (propertyValue == null) {
                return;
            }
            JavaType stringType = config.constructType(String.class);
            VirtualAnnotatedMember member = new VirtualAnnotatedMember((TypeResolutionContext)ac, ac.getRawType(), this.propertyName, stringType);
            SimpleBeanPropertyDefinition propDef = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, (PropertyName)PropertyName.construct((String)this.propertyName));
            AttributePropertyWriter propertyWriter = new AttributePropertyWriter(this.propertyName, (BeanPropertyDefinition)propDef, null, stringType){

                protected Object value(Object bean, JsonGenerator jgen, SerializerProvider prov) {
                    return propertyValue;
                }
            };
            properties.add((BeanPropertyWriter)propertyWriter);
        }

        public Version version() {
            return Version.unknownVersion();
        }
    }

    private static class TypeAddingModule
    extends SimpleModule {
        private static final AtomicInteger MODULE_ID_SEQ = new AtomicInteger(1);
        private final String propertyName;
        private final Supplier<Map<String, Class<?>>> subClassPropertyValues;

        private TypeAddingModule(String propertyName, Supplier<Map<String, Class<?>>> subClassPropertyValues) {
            super("TypeAddingModule-" + MODULE_ID_SEQ.getAndIncrement(), new Version(1, 0, 0, null, null, null));
            this.propertyName = Objects.requireNonNull(propertyName, "propertyName is null");
            this.subClassPropertyValues = Objects.requireNonNull(subClassPropertyValues, "subClassPropertyValues is null");
        }

        public void setupModule(Module.SetupContext context) {
            super.setupModule(context);
            Map invertedSubClassMap = (Map)this.subClassPropertyValues.get().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, Map.Entry::getKey));
            context.insertAnnotationIntrospector((AnnotationIntrospector)new TypeAddingIntrospector(this.propertyName, invertedSubClassMap));
        }
    }

    public static interface SubTypeSubBuilder<B> {
        default public <T extends B> SubTypeSubBuilder<B> add(Class<T> subClass) {
            return this.add(subClass, subClass.getSimpleName());
        }

        public <T extends B> SubTypeSubBuilder<B> add(Class<T> var1, String var2);

        default public SubTypeSubBuilder<B> addPermittedSubClasses() {
            return this.addPermittedSubClasses(Class::getSimpleName);
        }

        public SubTypeSubBuilder<B> addPermittedSubClasses(Function<Class<?>, String> var1);

        public <T> SubTypeSubBuilder<T> forBase(Class<T> var1, String var2);

        public JsonSubType build();
    }
}

