/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.CcrRequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.ccr.CcrStatsRequest;
import org.elasticsearch.client.ccr.CcrStatsResponse;
import org.elasticsearch.client.ccr.DeleteAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.FollowInfoRequest;
import org.elasticsearch.client.ccr.FollowInfoResponse;
import org.elasticsearch.client.ccr.FollowStatsRequest;
import org.elasticsearch.client.ccr.FollowStatsResponse;
import org.elasticsearch.client.ccr.ForgetFollowerRequest;
import org.elasticsearch.client.ccr.GetAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.GetAutoFollowPatternResponse;
import org.elasticsearch.client.ccr.PauseFollowRequest;
import org.elasticsearch.client.ccr.PutAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PutFollowRequest;
import org.elasticsearch.client.ccr.PutFollowResponse;
import org.elasticsearch.client.ccr.ResumeFollowRequest;
import org.elasticsearch.client.ccr.UnfollowRequest;
import org.elasticsearch.client.core.AcknowledgedResponse;
import org.elasticsearch.client.core.BroadcastResponse;

public final class CcrClient {
    private final RestHighLevelClient restHighLevelClient;

    CcrClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutFollowResponse putFollow(PutFollowRequest request, RequestOptions options) throws IOException {
        return (PutFollowResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::putFollow, options, PutFollowResponse::fromXContent, Collections.emptySet());
    }

    public void putFollowAsync(PutFollowRequest request, RequestOptions options, ActionListener<PutFollowResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::putFollow, options, PutFollowResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse pauseFollow(PauseFollowRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::pauseFollow, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void pauseFollowAsync(PauseFollowRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::pauseFollow, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse resumeFollow(ResumeFollowRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::resumeFollow, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void resumeFollowAsync(ResumeFollowRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::resumeFollow, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse unfollow(UnfollowRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::unfollow, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void unfollowAsync(UnfollowRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::unfollow, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public BroadcastResponse forgetFollower(ForgetFollowerRequest request, RequestOptions options) throws IOException {
        return (BroadcastResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::forgetFollower, options, BroadcastResponse::fromXContent, Collections.emptySet());
    }

    public void forgetFollowerAsync(ForgetFollowerRequest request, RequestOptions options, ActionListener<BroadcastResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::forgetFollower, options, BroadcastResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putAutoFollowPattern(PutAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::putAutoFollowPattern, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putAutoFollowPatternAsync(PutAutoFollowPatternRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::putAutoFollowPattern, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteAutoFollowPattern(DeleteAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::deleteAutoFollowPattern, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteAutoFollowPatternAsync(DeleteAutoFollowPatternRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::deleteAutoFollowPattern, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetAutoFollowPatternResponse getAutoFollowPattern(GetAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return (GetAutoFollowPatternResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getAutoFollowPattern, options, GetAutoFollowPatternResponse::fromXContent, Collections.emptySet());
    }

    public void getAutoFollowPatternAsync(GetAutoFollowPatternRequest request, RequestOptions options, ActionListener<GetAutoFollowPatternResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getAutoFollowPattern, options, GetAutoFollowPatternResponse::fromXContent, listener, Collections.emptySet());
    }

    public CcrStatsResponse getCcrStats(CcrStatsRequest request, RequestOptions options) throws IOException {
        return (CcrStatsResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getCcrStats, options, CcrStatsResponse::fromXContent, Collections.emptySet());
    }

    public void getCcrStatsAsync(CcrStatsRequest request, RequestOptions options, ActionListener<CcrStatsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getCcrStats, options, CcrStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public FollowStatsResponse getFollowStats(FollowStatsRequest request, RequestOptions options) throws IOException {
        return (FollowStatsResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getFollowStats, options, FollowStatsResponse::fromXContent, Collections.emptySet());
    }

    public void getFollowStatsAsync(FollowStatsRequest request, RequestOptions options, ActionListener<FollowStatsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getFollowStats, options, FollowStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public FollowInfoResponse getFollowInfo(FollowInfoRequest request, RequestOptions options) throws IOException {
        return (FollowInfoResponse)this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getFollowInfo, options, FollowInfoResponse::fromXContent, Collections.emptySet());
    }

    public void getFollowInfoAsync(FollowInfoRequest request, RequestOptions options, ActionListener<FollowInfoResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getFollowInfo, options, FollowInfoResponse::fromXContent, listener, Collections.emptySet());
    }
}

