/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.druid;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcRelationHandle;
import io.trino.plugin.jdbc.JdbcRemoteIdentifiers;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Range;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiFunction;

public class DruidJdbcClient
extends BaseJdbcClient {
    private static final String DRUID_CATALOG = "druid";
    private static final String DRUID_SCHEMA = "druid";
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
    private static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);

    @Inject
    public DruidJdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, false);
    }

    public Collection<String> listSchemas(Connection connection) {
        return ImmutableSet.of((Object)"druid");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        String jdbcSchemaName = schemaTableName.getSchemaName();
        String jdbcTableName = schemaTableName.getTableName();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Optional<JdbcTableHandle> optional;
            block19: {
                ArrayList<JdbcTableHandle> tableHandles;
                ResultSet resultSet;
                block17: {
                    block18: {
                        ConnectorIdentity identity = session.getIdentity();
                        RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
                        String remoteSchema = this.getIdentifierMapping().toRemoteSchemaName(remoteIdentifiers, identity, jdbcSchemaName);
                        String remoteTable = this.getIdentifierMapping().toRemoteTableName(remoteIdentifiers, identity, remoteSchema, jdbcTableName);
                        resultSet = this.getTables(connection, Optional.of(remoteSchema), Optional.of(remoteTable));
                        try {
                            tableHandles = new ArrayList<JdbcTableHandle>();
                            while (resultSet.next()) {
                                String schemaName = resultSet.getString("TABLE_SCHEM");
                                String tableName = resultSet.getString("TABLE_NAME");
                                if (!Objects.equals(schemaName, remoteSchema) || !Objects.equals(tableName, remoteTable)) continue;
                                tableHandles.add(new JdbcTableHandle(schemaTableName, new RemoteTableName(Optional.of("druid"), Optional.ofNullable(schemaName), tableName), Optional.empty()));
                            }
                            if (!tableHandles.isEmpty()) break block17;
                            optional = Optional.empty();
                            if (resultSet == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional;
                }
                optional = Optional.of((JdbcTableHandle)Iterables.getOnlyElement(tableHandles));
                if (resultSet == null) break block19;
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables("druid", "druid", tableName.orElse(null), null);
    }

    public Optional<String> getTableComment(ResultSet resultSet) {
        return Optional.empty();
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (typeHandle.getJdbcType()) {
            case -7: 
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: 
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int decimalDigits = typeHandle.getRequiredDecimalDigits();
                int precision = typeHandle.getRequiredColumnSize() + Math.max(-decimalDigits, 0);
                if (precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case -15: 
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case 12: {
                int columnSize = typeHandle.getRequiredColumnSize();
                if (columnSize == -1) {
                    return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)VarcharType.createUnboundedVarcharType(), (boolean)true));
                }
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)columnSize, (boolean)true));
            }
            case -16: 
            case -9: 
            case -1: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMappingUsingSqlDate());
            }
            case 92: {
                return Optional.of(StandardColumnMappings.timeColumnMappingUsingSqlTime());
            }
            case 93: {
                return Optional.of(DruidJdbcClient.timestampColumnMappingUsingSqlTimestampWithFullPushdown(TimestampType.TIMESTAMP_MILLIS));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return DruidJdbcClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.legacyToWriteMapping(type);
    }

    public static ColumnMapping timestampColumnMappingUsingSqlTimestampWithFullPushdown(TimestampType timestampType) {
        Preconditions.checkArgument((timestampType.getPrecision() <= 3 ? 1 : 0) != 0, (String)"Precision is out of range: %s", (int)timestampType.getPrecision());
        return ColumnMapping.longMapping((Type)timestampType, (resultSet, columnIndex) -> {
            Instant instant = Instant.ofEpochMilli(resultSet.getTimestamp(columnIndex, UTC_CALENDAR).getTime());
            LocalDateTime timestamp = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
            return StandardColumnMappings.toTrinoTimestamp((TimestampType)timestampType, (LocalDateTime)timestamp);
        }, (LongWriteFunction)DruidJdbcClient.timestampWriteFunctionUsingSqlTimestamp(timestampType), (session, domain) -> {
            boolean canPushdownFilter = (Boolean)domain.getValues().getValuesProcessor().transform(ranges -> ranges.getOrderedRanges().stream().allMatch(DruidJdbcClient::hasSecondPrecision), discreteValues -> {
                throw new UnsupportedOperationException("Not supported for discrete values");
            }, allOrNone -> true);
            if (canPushdownFilter) {
                return PredicatePushdownController.FULL_PUSHDOWN.apply(session, domain);
            }
            return PredicatePushdownController.DISABLE_PUSHDOWN.apply(session, domain);
        });
    }

    public static LongWriteFunction timestampWriteFunctionUsingSqlTimestamp(TimestampType timestampType) {
        Preconditions.checkArgument((timestampType.getPrecision() <= 3 ? 1 : 0) != 0, (String)"Precision is out of range: %s", (int)timestampType.getPrecision());
        return new LongWriteFunction(){

            public String getBindExpression() {
                return "CAST(? AS TIMESTAMP)";
            }

            public void set(PreparedStatement statement, int index, long value) throws SQLException {
                statement.setString(index, LOCAL_DATE_TIME.format(StandardColumnMappings.fromTrinoTimestamp((long)value)));
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasSecondPrecision(Range range) {
        if (range.getLowValue().map(Long.class::cast).map(DruidJdbcClient::hasSecondPrecision).orElse(true) == false) return false;
        if (range.getHighValue().map(Long.class::cast).map(DruidJdbcClient::hasSecondPrecision).orElse(true) == false) return false;
        return true;
    }

    private static boolean hasSecondPrecision(long epochMicros) {
        return epochMicros % 1000000L == 0L;
    }

    protected PreparedQuery prepareQuery(ConnectorSession session, Connection connection, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, ParameterizedExpression> columnExpressions, Optional<JdbcSplit> split) {
        return super.prepareQuery(session, connection, this.prepareTableHandleForQuery(table), groupingSets, columns, columnExpressions, split);
    }

    private JdbcTableHandle prepareTableHandleForQuery(JdbcTableHandle table) {
        if (table.isNamedRelation()) {
            JdbcNamedRelationHandle relation = table.getRequiredNamedRelation();
            RemoteTableName remoteTableName = relation.getRemoteTableName();
            String schemaName = remoteTableName.getSchemaName().orElse(null);
            Preconditions.checkArgument((boolean)"druid".equals(schemaName), (Object)"Only \"druid\" schema is supported");
            table = new JdbcTableHandle((JdbcRelationHandle)new JdbcNamedRelationHandle(relation.getSchemaTableName(), new RemoteTableName(Optional.empty(), remoteTableName.getSchemaName(), remoteTableName.getTableName()), Optional.empty()), table.getConstraint(), table.getConstraintExpressions(), table.getSortOrder(), table.getLimit(), table.getColumns(), table.getOtherReferencedTables(), table.getNextSyntheticColumnId(), table.getAuthorization(), table.getUpdateAssignments());
        }
        return table;
    }

    protected ResultSet getColumns(JdbcTableHandle tableHandle, DatabaseMetaData metadata) throws SQLException {
        RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
        return metadata.getColumns(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName(), null);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support modifying table rows");
    }

    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support modifying table rows");
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with data");
    }

    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support inserts");
    }

    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns");
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming columns");
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping columns");
    }

    public void dropTable(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping tables");
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables");
    }

    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support truncating tables");
    }

    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support inserts");
    }

    public void createSchema(ConnectorSession session, String schemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating schemas");
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas");
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    private WriteMapping legacyToWriteMapping(Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("char(" + charType.getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type == VarbinaryType.VARBINARY) {
            return WriteMapping.sliceMapping((String)"varbinary", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunctionUsingSqlDate());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public RemoteIdentifiers getRemoteIdentifiers(Connection connection) {
        return new JdbcRemoteIdentifiers((BaseJdbcClient)this, connection, false);
    }
}

