/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.logging;

import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public enum SessionInterpolatedValues implements FormatInterpolator.InterpolatedValue<ConnectorSession>
{
    QUERY_ID(ConnectorSession::getQueryId),
    SOURCE(new SanitizedValuesProvider(session -> session.getSource().orElse(""), "$SOURCE")),
    USER(ConnectorSession::getUser),
    TRACE_TOKEN(new SanitizedValuesProvider(session -> session.getTraceToken().orElse(""), "$TRACE_TOKEN"));

    private final Function<ConnectorSession, String> valueProvider;

    private SessionInterpolatedValues(Function<ConnectorSession, String> valueProvider) {
        this.valueProvider = valueProvider;
    }

    @Override
    public String value(ConnectorSession session) {
        return this.valueProvider.apply(session);
    }

    static class SanitizedValuesProvider
    implements Function<ConnectorSession, String> {
        private static final Predicate<String> VALIDATION_MATCHER = Pattern.compile("^[\\w_-]*$").asMatchPredicate();
        private final Function<ConnectorSession, String> valueProvider;
        private final String name;

        private SanitizedValuesProvider(Function<ConnectorSession, String> valueProvider, String name) {
            this.valueProvider = Objects.requireNonNull(valueProvider, "valueProvider is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @Override
        public String apply(ConnectorSession session) {
            String value = this.valueProvider.apply(session);
            if (VALIDATION_MATCHER.test(value)) {
                return value;
            }
            throw new SecurityException("Passed value %s as %s does not meet security criteria. It can contain only letters, digits, underscores and hyphens".formatted(value, this.name));
        }
    }
}

