/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;

public class BlackHoleNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;
    private final TypeOperators typeOperators;

    public BlackHoleNodePartitioningProvider(NodeManager nodeManager, TypeOperators typeOperators) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.typeOperators = typeOperators;
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return ConnectorBucketNodeMap.createBucketNodeMap((int)this.nodeManager.getRequiredWorkerNodes().size());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Black hole connector does not supported distributed reads");
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        List hashCodeInvokers = (List)partitionChannelTypes.stream().map(type -> this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).collect(ImmutableList.toImmutableList());
        return (page, position) -> {
            long hash = 13L;
            for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                try {
                    hash = 31L * hash + ((MethodHandle)hashCodeInvokers.get(i)).invokeExact(page.getBlock(i), 0);
                    continue;
                }
                catch (Throwable throwable) {
                    Throwables.throwIfUnchecked((Throwable)throwable);
                    throw new RuntimeException(throwable);
                }
            }
            return (int)((hash &= Long.MAX_VALUE) % (long)bucketCount);
        };
    }
}

