/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.blackhole;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.blackhole.BlackHoleMetadata;
import io.trino.plugin.blackhole.BlackHoleNodePartitioningProvider;
import io.trino.plugin.blackhole.BlackHolePageSinkProvider;
import io.trino.plugin.blackhole.BlackHolePageSourceProvider;
import io.trino.plugin.blackhole.BlackHoleSplitManager;
import io.trino.plugin.blackhole.BlackHoleTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class BlackHoleConnector
implements Connector {
    public static final String SPLIT_COUNT_PROPERTY = "split_count";
    public static final String PAGES_PER_SPLIT_PROPERTY = "pages_per_split";
    public static final String ROWS_PER_PAGE_PROPERTY = "rows_per_page";
    public static final String FIELD_LENGTH_PROPERTY = "field_length";
    public static final String DISTRIBUTED_ON = "distributed_on";
    public static final String PAGE_PROCESSING_DELAY = "page_processing_delay";
    private final BlackHoleMetadata metadata;
    private final BlackHoleSplitManager splitManager;
    private final BlackHolePageSourceProvider pageSourceProvider;
    private final BlackHolePageSinkProvider pageSinkProvider;
    private final BlackHoleNodePartitioningProvider partitioningProvider;
    private final TypeManager typeManager;
    private final ExecutorService executorService;

    public BlackHoleConnector(BlackHoleMetadata metadata, BlackHoleSplitManager splitManager, BlackHolePageSourceProvider pageSourceProvider, BlackHolePageSinkProvider pageSinkProvider, BlackHoleNodePartitioningProvider partitioningProvider, TypeManager typeManager, ExecutorService executorService) {
        this.metadata = metadata;
        this.splitManager = splitManager;
        this.pageSourceProvider = pageSourceProvider;
        this.pageSinkProvider = pageSinkProvider;
        this.partitioningProvider = partitioningProvider;
        this.typeManager = typeManager;
        this.executorService = executorService;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return BlackHoleTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return ImmutableList.of((Object)PropertyMetadata.integerProperty((String)SPLIT_COUNT_PROPERTY, (String)"Number of splits generated by this table", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerProperty((String)PAGES_PER_SPLIT_PROPERTY, (String)"Number of pages per each split generated by this table", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerProperty((String)ROWS_PER_PAGE_PROPERTY, (String)"Number of rows per each page generated by this table", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerProperty((String)FIELD_LENGTH_PROPERTY, (String)"Overwrite default length (16) of variable length columns, such as VARCHAR or VARBINARY", (Integer)16, (boolean)false), (Object)new PropertyMetadata(DISTRIBUTED_ON, "Distribution columns", this.typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.createUnboundedVarcharType().getTypeSignature()))), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((List)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), List.class::cast), (Object)PropertyMetadataUtil.durationProperty((String)PAGE_PROCESSING_DELAY, (String)"Sleep duration before processing each page", (Duration)new Duration(0.0, TimeUnit.SECONDS), (boolean)false));
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.partitioningProvider;
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }
}

