/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.TDigest;
import io.trino.spi.metrics.Distribution;
import java.util.Base64;

public class TDigestHistogram
implements Distribution<TDigestHistogram> {
    @JsonSerialize(converter=TDigestToBase64Converter.class)
    @JsonDeserialize(converter=Base64ToTDigestConverter.class)
    private final TDigest digest;

    @JsonCreator
    public TDigestHistogram(TDigest digest) {
        this.digest = digest;
    }

    @JsonProperty
    public TDigest getDigest() {
        return this.digest;
    }

    public TDigestHistogram mergeWith(TDigestHistogram other) {
        TDigest result = TDigest.copyOf((TDigest)this.digest);
        result.mergeWith(other.getDigest());
        return new TDigestHistogram(result);
    }

    public long getTotal() {
        return (long)this.digest.getCount();
    }

    public double getPercentile(double percentile) {
        return this.digest.valueAt(percentile / 100.0);
    }

    public static class Base64ToTDigestConverter
    extends StdConverter<String, TDigest> {
        public TDigest convert(String value) {
            Slice slice = Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(value));
            return TDigest.deserialize((Slice)slice);
        }
    }

    public static class TDigestToBase64Converter
    extends StdConverter<TDigest, String> {
        public String convert(TDigest value) {
            Slice slice = value.serialize();
            return Base64.getEncoder().encodeToString(slice.getBytes());
        }
    }
}

