/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.logging;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.plugin.base.logging.SessionInterpolatedValues;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.logging.FormatBasedRemoteQueryModifierConfig;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;

public class FormatBasedRemoteQueryModifier
implements RemoteQueryModifier {
    private final FormatInterpolator<ConnectorSession> interpolator;

    @Inject
    public FormatBasedRemoteQueryModifier(FormatBasedRemoteQueryModifierConfig config) {
        String commentFormat = Objects.requireNonNull(config, "config is null").getFormat();
        Preconditions.checkState((!commentFormat.isBlank() ? 1 : 0) != 0, (Object)"comment format is blank");
        this.interpolator = new FormatInterpolator(commentFormat, (FormatInterpolator.InterpolatedValue[])SessionInterpolatedValues.values());
    }

    @Override
    public String apply(ConnectorSession session, String query) {
        return query + " /*" + this.checkForSqlInjection(this.interpolator.interpolate((Object)session)) + "*/";
    }

    private String checkForSqlInjection(String sql) {
        if (sql.contains("*/")) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, "Rendering metadata using 'query.comment-format' does not meet security criteria: " + sql);
        }
        return sql;
    }
}

