/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.jmx;

import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class JdbcApiStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat failures = new CounterStat();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V, E extends Exception> V wrap(ThrowingCallable<V, E> callable) throws E {
        try (TimeStat.BlockTimer ignored = this.time.time();){
            V v = callable.call();
            return v;
        }
        catch (Exception e) {
            this.failures.update(1L);
            throw e;
        }
    }

    public <E extends Exception> void wrap(ThrowingRunnable<E> callable) throws E {
        try (TimeStat.BlockTimer ignored = this.time.time();){
            callable.run();
        }
        catch (Exception e) {
            this.failures.update(1L);
            throw e;
        }
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getFailures() {
        return this.failures;
    }

    public static interface ThrowingCallable<V, E extends Exception> {
        public V call() throws E;
    }

    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }
}

