/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.JdbcAssignmentItem;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcRelationHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.Constant;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public final class JdbcTableHandle
extends BaseJdbcConnectorTableHandle {
    private final JdbcRelationHandle relationHandle;
    private final TupleDomain<ColumnHandle> constraint;
    private final List<ParameterizedExpression> constraintExpressions;
    private final Optional<List<JdbcSortItem>> sortOrder;
    private final OptionalLong limit;
    private final Optional<List<JdbcColumnHandle>> columns;
    private final Optional<Set<SchemaTableName>> otherReferencedTables;
    private final int nextSyntheticColumnId;
    private final Optional<String> authorization;
    private final List<JdbcAssignmentItem> updateAssignments;

    public JdbcTableHandle(SchemaTableName schemaTableName, RemoteTableName remoteTableName, Optional<String> comment) {
        this(new JdbcNamedRelationHandle(schemaTableName, remoteTableName, comment), (TupleDomain<ColumnHandle>)TupleDomain.all(), (List<ParameterizedExpression>)ImmutableList.of(), Optional.empty(), OptionalLong.empty(), Optional.empty(), Optional.of(ImmutableSet.of()), 0, Optional.empty(), (List<JdbcAssignmentItem>)ImmutableList.of());
    }

    @JsonCreator
    public JdbcTableHandle(@JsonProperty(value="relationHandle") JdbcRelationHandle relationHandle, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="constraintExpressions") List<ParameterizedExpression> constraintExpressions, @JsonProperty(value="sortOrder") Optional<List<JdbcSortItem>> sortOrder, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="columns") Optional<List<JdbcColumnHandle>> columns, @JsonProperty(value="otherReferencedTables") Optional<Set<SchemaTableName>> otherReferencedTables, @JsonProperty(value="nextSyntheticColumnId") int nextSyntheticColumnId, @JsonProperty(value="authorization") Optional<String> authorization, @JsonProperty(value="updateAssignments") List<JdbcAssignmentItem> updateAssignments) {
        this.relationHandle = Objects.requireNonNull(relationHandle, "relationHandle is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.constraintExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(constraintExpressions, "constraintExpressions is null"));
        this.sortOrder = sortOrder.map(ImmutableList::copyOf);
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.columns = columns.map(ImmutableList::copyOf);
        this.otherReferencedTables = otherReferencedTables.map(ImmutableSet::copyOf);
        this.nextSyntheticColumnId = nextSyntheticColumnId;
        this.authorization = Objects.requireNonNull(authorization, "authorization is null");
        this.updateAssignments = Objects.requireNonNull(updateAssignments, "updateAssignments is null");
    }

    public JdbcTableHandle intersectedWithConstraint(TupleDomain<ColumnHandle> newConstraint) {
        return new JdbcTableHandle(this.relationHandle, (TupleDomain<ColumnHandle>)this.constraint.intersect(newConstraint), this.constraintExpressions, this.sortOrder, this.limit, this.columns, this.otherReferencedTables, this.nextSyntheticColumnId, this.authorization, this.updateAssignments);
    }

    public JdbcTableHandle withAssignments(Map<ColumnHandle, Constant> assignments) {
        return new JdbcTableHandle(this.relationHandle, this.constraint, this.constraintExpressions, this.sortOrder, this.limit, this.columns, this.otherReferencedTables, this.nextSyntheticColumnId, this.authorization, (List)assignments.entrySet().stream().map(e -> new JdbcAssignmentItem((JdbcColumnHandle)e.getKey(), new QueryParameter(((Constant)e.getValue()).getType(), Optional.ofNullable(((Constant)e.getValue()).getValue())))).collect(ImmutableList.toImmutableList()));
    }

    public JdbcNamedRelationHandle asPlainTable() {
        Preconditions.checkState((!this.isSynthetic() ? 1 : 0) != 0, (String)"The table handle does not represent a plain table: %s", (Object)this);
        return this.getRequiredNamedRelation();
    }

    @JsonIgnore
    public JdbcNamedRelationHandle getRequiredNamedRelation() {
        Preconditions.checkState((boolean)this.isNamedRelation(), (String)"The table handle does not represent a named relation: %s", (Object)this);
        return (JdbcNamedRelationHandle)this.relationHandle;
    }

    @JsonProperty
    public JdbcRelationHandle getRelationHandle() {
        return this.relationHandle;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public List<ParameterizedExpression> getConstraintExpressions() {
        return this.constraintExpressions;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @Override
    @JsonProperty
    public Optional<List<JdbcColumnHandle>> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<List<JdbcSortItem>> getSortOrder() {
        return this.sortOrder;
    }

    @JsonProperty
    public Optional<Set<SchemaTableName>> getOtherReferencedTables() {
        return this.otherReferencedTables;
    }

    @JsonProperty
    public List<JdbcAssignmentItem> getUpdateAssignments() {
        return this.updateAssignments;
    }

    @JsonIgnore
    public Optional<Set<SchemaTableName>> getAllReferencedTables() {
        return this.getOtherReferencedTables().map(otherReferencedTables -> {
            if (!this.isNamedRelation()) {
                return otherReferencedTables;
            }
            return ImmutableSet.builder().addAll((Iterable)otherReferencedTables).add((Object)this.getRequiredNamedRelation().getSchemaTableName()).build();
        });
    }

    boolean mayReference(SchemaTableName schemaTableName) {
        if (this.isNamedRelation() && this.getRequiredNamedRelation().getSchemaTableName().equals((Object)schemaTableName)) {
            return true;
        }
        return this.getOtherReferencedTables().map(otherReferencedTables -> otherReferencedTables.contains(schemaTableName)).orElse(true);
    }

    @JsonProperty
    public int getNextSyntheticColumnId() {
        return this.nextSyntheticColumnId;
    }

    @JsonProperty
    public Optional<String> getAuthorization() {
        return this.authorization;
    }

    @JsonIgnore
    public boolean isSynthetic() {
        return !this.isNamedRelation() || !this.constraint.isAll() || !this.constraintExpressions.isEmpty() || this.sortOrder.isPresent() || this.limit.isPresent();
    }

    @JsonIgnore
    public boolean isNamedRelation() {
        return this.relationHandle instanceof JdbcNamedRelationHandle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcTableHandle o = (JdbcTableHandle)obj;
        return Objects.equals(this.relationHandle, o.relationHandle) && Objects.equals(this.constraint, o.constraint) && Objects.equals(this.constraintExpressions, o.constraintExpressions) && Objects.equals(this.sortOrder, o.sortOrder) && Objects.equals(this.limit, o.limit) && Objects.equals(this.columns, o.columns) && this.nextSyntheticColumnId == o.nextSyntheticColumnId && Objects.equals(this.authorization, o.authorization) && Objects.equals(this.updateAssignments, o.updateAssignments);
    }

    public int hashCode() {
        return Objects.hash(this.relationHandle, this.constraint, this.constraintExpressions, this.sortOrder, this.limit, this.columns, this.nextSyntheticColumnId, this.authorization, this.updateAssignments);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.relationHandle);
        if (this.constraint.isNone()) {
            builder.append(" constraint=FALSE");
        } else if (!this.constraint.isAll()) {
            builder.append(" constraint on ");
            builder.append(((Map)this.constraint.getDomains().orElseThrow()).keySet().stream().map(columnHandle -> ((JdbcColumnHandle)columnHandle).getColumnName()).collect(Collectors.joining(", ", "[", "]")));
        }
        if (!this.constraintExpressions.isEmpty()) {
            builder.append(" constraints=").append(this.constraintExpressions);
        }
        this.sortOrder.ifPresent(value -> builder.append(" sortOrder=").append(value));
        this.limit.ifPresent(value -> builder.append(" limit=").append(value));
        this.columns.ifPresent(value -> builder.append(" columns=").append(value));
        this.authorization.ifPresent(value -> builder.append(" authorization=").append((String)value));
        if (!this.updateAssignments.isEmpty()) {
            builder.append(" updateAssignments=");
            this.updateAssignments.forEach(builder::append);
        }
        return builder.toString();
    }
}

