/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.QueryParameter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class JdbcExpression {
    private final String expression;
    private final List<QueryParameter> parameters;
    private final JdbcTypeHandle jdbcTypeHandle;

    public JdbcExpression(String expression, List<QueryParameter> parameters, JdbcTypeHandle jdbcTypeHandle) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.jdbcTypeHandle = Objects.requireNonNull(jdbcTypeHandle, "jdbcTypeHandle is null");
    }

    public String getExpression() {
        return this.expression;
    }

    public List<QueryParameter> getParameters() {
        return this.parameters;
    }

    public JdbcTypeHandle getJdbcTypeHandle() {
        return this.jdbcTypeHandle;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("parameters", this.parameters).add("jdbcTypeHandle", (Object)this.jdbcTypeHandle).toString();
    }
}

