/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.logging;

import io.trino.plugin.jdbc.logging.FormatBasedRemoteQueryModifier;
import io.trino.plugin.jdbc.logging.FormatBasedRemoteQueryModifierConfig;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.TestingConnectorSession;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestFormatBasedRemoteQueryModifier {
    @Test
    public void testCreatingCommentToAppendBasedOnFormatAndConnectorSession() {
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setTraceToken("trace_token").setSource("source").setIdentity(ConnectorIdentity.ofUser((String)"Alice")).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("Query=$QUERY_ID Execution for user=$USER with source=$SOURCE ttoken=$TRACE_TOKEN");
        String modifiedQuery = modifier.apply((ConnectorSession)connectorSession, "SELECT * from USERS");
        Assertions.assertThat((String)modifiedQuery).isEqualTo("SELECT * from USERS /*Query=%s Execution for user=%s with source=%s ttoken=%s*/", new Object[]{connectorSession.getQueryId(), "Alice", "source", "trace_token"});
    }

    @Test
    public void testCreatingCommentWithDuplicatedPredefinedValues() {
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setTraceToken("trace_token").setSource("source").setIdentity(ConnectorIdentity.ofUser((String)"Alice")).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("$QUERY_ID, $QUERY_ID, $QUERY_ID, $QUERY_ID, $USER, $USER, $SOURCE, $SOURCE, $SOURCE, $TRACE_TOKEN, $TRACE_TOKEN");
        String modifiedQuery = modifier.apply((ConnectorSession)connectorSession, "SELECT * from USERS");
        Assertions.assertThat((String)modifiedQuery).isEqualTo("SELECT * from USERS /*%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s*/", new Object[]{connectorSession.getQueryId(), connectorSession.getQueryId(), connectorSession.getQueryId(), connectorSession.getQueryId(), "Alice", "Alice", "source", "source", "source", "trace_token", "trace_token"});
    }

    @Test
    public void testForSQLInjectionsByTraceToken() {
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setTraceToken("*/; DROP TABLE TABLE_A; /*").setSource("source").setIdentity(ConnectorIdentity.ofUser((String)"Alice")).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("Query=$QUERY_ID Execution for user=$USER with source=$SOURCE ttoken=$TRACE_TOKEN");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> modifier.apply((ConnectorSession)connectorSession, "SELECT * from USERS")).isInstanceOf(TrinoException.class)).hasMessage("Passed value */; DROP TABLE TABLE_A; /* as $TRACE_TOKEN does not meet security criteria. It can contain only letters, digits, underscores and hyphens");
    }

    @Test
    public void testForSQLInjectionsBySource() {
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setTraceToken("trace_token").setSource("*/; DROP TABLE TABLE_A; /*").setIdentity(ConnectorIdentity.ofUser((String)"Alice")).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("Query=$QUERY_ID Execution for user=$USER with source=$SOURCE ttoken=$TRACE_TOKEN");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> modifier.apply((ConnectorSession)connectorSession, "SELECT * from USERS")).isInstanceOf(TrinoException.class)).hasMessage("Passed value */; DROP TABLE TABLE_A; /* as $SOURCE does not meet security criteria. It can contain only letters, digits, underscores and hyphens");
    }

    @Test
    public void testFormatQueryModifierWithUser() {
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setIdentity(ConnectorIdentity.ofUser((String)"Alice")).setSource("$invalid@value").setTraceToken("#invalid&value").build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("user=$USER");
        Assertions.assertThat((String)modifier.apply((ConnectorSession)connectorSession, "SELECT * FROM USERS")).isEqualTo("SELECT * FROM USERS /*user=Alice*/");
    }

    @Test
    public void testFormatQueryModifierWithSource() {
        String validValue = "valid-value";
        String invalidValue = "$invalid@value";
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setIdentity(ConnectorIdentity.ofUser((String)"Alice")).setSource(validValue).setTraceToken(invalidValue).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("source=$SOURCE");
        Assertions.assertThat((String)modifier.apply((ConnectorSession)connectorSession, "SELECT * FROM USERS")).isEqualTo("SELECT * FROM USERS /*source=valid-value*/");
    }

    @Test
    public void testFormatQueryModifierWithTraceToken() {
        String validValue = "valid-value";
        String invalidValue = "$invalid@value";
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setIdentity(ConnectorIdentity.ofUser((String)"Alice")).setSource(invalidValue).setTraceToken(validValue).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("ttoken=$TRACE_TOKEN");
        Assertions.assertThat((String)modifier.apply((ConnectorSession)connectorSession, "SELECT * FROM USERS")).isEqualTo("SELECT * FROM USERS /*ttoken=valid-value*/");
    }

    @Test(dataProvider="validValues")
    public void testFormatWithValidValues(String value) {
        TestingConnectorSession connectorSession = TestingConnectorSession.builder().setIdentity(ConnectorIdentity.ofUser((String)"Alice")).setSource(value).setTraceToken(value).build();
        FormatBasedRemoteQueryModifier modifier = TestFormatBasedRemoteQueryModifier.createRemoteQueryModifier("source=$SOURCE ttoken=$TRACE_TOKEN");
        String modifiedQuery = modifier.apply((ConnectorSession)connectorSession, "SELECT * FROM USERS");
        Assertions.assertThat((String)modifiedQuery).isEqualTo("SELECT * FROM USERS /*source=%1$s ttoken=%1$s*/".formatted(value));
    }

    @DataProvider
    public Object[][] validValues() {
        return new Object[][]{{"trino"}, {"123"}, {"1t2r3i4n0"}, {"trino-cli"}, {"trino_cli"}, {"trino-cli_123"}, {"123_trino-cli"}, {"123-trino_cli"}, {"-trino-cli"}, {"_trino_cli"}};
    }

    private static FormatBasedRemoteQueryModifier createRemoteQueryModifier(String commentFormat) {
        return new FormatBasedRemoteQueryModifier(new FormatBasedRemoteQueryModifierConfig().setFormat(commentFormat));
    }
}

