/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.BaseTestRewriteLikeWithCaseSensitivity;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.expression.RewriteLikeWithCaseSensitivity;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestRewriteLikeWithCaseSensitivity
extends BaseTestRewriteLikeWithCaseSensitivity {
    private final RewriteLikeWithCaseSensitivity rewrite = new RewriteLikeWithCaseSensitivity();

    @Override
    protected ConnectorExpressionRule<Call, ParameterizedExpression> getRewrite() {
        return this.rewrite;
    }

    @Test
    public void testRewriteLikeEscapeCallInvalidNumberOfArguments() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeCallInvalidNumberOfArguments() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeCallInvalidTypeValue() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)BigintType.BIGINT), new Variable("pattern", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeCallInvalidTypePattern() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)BigintType.BIGINT)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeCallOnCaseInsensitiveValue() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_insensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeCallOnCaseSensitiveValue() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)VarcharType.VARCHAR)));
        ParameterizedExpression rewritten = this.apply(expression).orElseThrow();
        Assertions.assertThat((String)rewritten.expression()).isEqualTo("\"case_sensitive_value\" LIKE \"pattern\"");
        Assertions.assertThat((List)rewritten.parameters()).isEqualTo(List.of(new QueryParameter((Type)VarcharType.VARCHAR, Optional.of("case_sensitive_value")), new QueryParameter((Type)VarcharType.VARCHAR, Optional.of("pattern"))));
    }
}

