/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.matching.Match;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;

public abstract class BaseTestRewriteLikeWithCaseSensitivity {
    protected abstract ConnectorExpressionRule<Call, ParameterizedExpression> getRewrite();

    protected Optional<ParameterizedExpression> apply(Call expression) {
        Optional match = (Optional)this.getRewrite().getPattern().match((Object)expression).collect(MoreCollectors.toOptional());
        if (match.isEmpty()) {
            return Optional.empty();
        }
        return this.getRewrite().rewrite((ConnectorExpression)expression, ((Match)match.get()).captures(), (ConnectorExpressionRule.RewriteContext)new ConnectorExpressionRule.RewriteContext<ParameterizedExpression>(){

            public Map<String, ColumnHandle> getAssignments() {
                return Map.of("case_insensitive_value", new JdbcColumnHandle("case_insensitive_value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)VarcharType.VARCHAR), "case_sensitive_value", new JdbcColumnHandle("case_sensitive_value", new JdbcTypeHandle(12, Optional.of("varchar"), Optional.of(10), Optional.empty(), Optional.empty(), Optional.of(CaseSensitivity.CASE_SENSITIVE)), (Type)VarcharType.VARCHAR));
            }

            public ConnectorSession getSession() {
                throw new UnsupportedOperationException();
            }

            public Optional<ParameterizedExpression> defaultRewrite(ConnectorExpression expression) {
                if (expression instanceof Variable) {
                    String name = ((Variable)expression).getName();
                    return Optional.of(new ParameterizedExpression("\"" + name.replace("\"", "\"\"") + "\"", (List)ImmutableList.of((Object)new QueryParameter(expression.getType(), Optional.of(name)))));
                }
                return Optional.empty();
            }
        });
    }

    protected void assertNoRewrite(Call expression) {
        Optional<ParameterizedExpression> rewritten = this.apply(expression);
        Assertions.assertThat(rewritten).isEmpty();
    }
}

