/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.CredentialProviderModule;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestExtraCredentialProvider {
    @Test
    public void testUserNameOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"user-credential-name", (Object)"user");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<ConnectorIdentity> identity = Optional.of(ConnectorIdentity.forUser((String)"user").withExtraCredentials((Map)ImmutableMap.of((Object)"user", (Object)"overwritten_user")).build());
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(identity).get())).isEqualTo("overwritten_user");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(identity).get())).isEqualTo("default_password");
    }

    @Test
    public void testPasswordOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"password-credential-name", (Object)"password");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<ConnectorIdentity> identity = Optional.of(ConnectorIdentity.forUser((String)"user").withExtraCredentials((Map)ImmutableMap.of((Object)"password", (Object)"overwritten_password")).build());
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(identity).get())).isEqualTo("default_user");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(identity).get())).isEqualTo("overwritten_password");
    }

    @Test
    public void testCredentialsOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"user-credential-name", (Object)"user", (Object)"password-credential-name", (Object)"password");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<ConnectorIdentity> identity = Optional.of(ConnectorIdentity.forUser((String)"user").withExtraCredentials((Map)ImmutableMap.of((Object)"user", (Object)"overwritten_user", (Object)"password", (Object)"overwritten_password")).build());
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(identity).get())).isEqualTo("overwritten_user");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(identity).get())).isEqualTo("overwritten_password");
    }

    @Test
    public void testCredentialsNotOverwritten() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-user", (Object)"default_user", (Object)"connection-password", (Object)"default_password", (Object)"user-credential-name", (Object)"user", (Object)"password-credential-name", (Object)"password");
        CredentialProvider credentialProvider = TestExtraCredentialProvider.getCredentialProvider((Map<String, String>)properties);
        Optional<ConnectorIdentity> identity = Optional.of(ConnectorIdentity.ofUser((String)"user"));
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(identity).get())).isEqualTo("default_user");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(identity).get())).isEqualTo("default_password");
        identity = Optional.of(ConnectorIdentity.forUser((String)"user").withExtraCredentials((Map)ImmutableMap.of((Object)"connection_user", (Object)"overwritten_user", (Object)"connection_password", (Object)"overwritten_password")).build());
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(identity).get())).isEqualTo("default_user");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(identity).get())).isEqualTo("default_password");
    }

    private static CredentialProvider getCredentialProvider(Map<String, String> properties) {
        return (CredentialProvider)new Bootstrap(new Module[]{new CredentialProviderModule()}).doNotInitializeLogging().quiet().setRequiredConfigurationProperties(properties).initialize().getInstance(CredentialProvider.class);
    }
}

