/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.CredentialProviderModule;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestCredentialProvider {
    @Test
    public void testInlineCredentialProvider() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-url", (Object)"jdbc:h2:mem:config", (Object)"connection-user", (Object)"user_from_inline", (Object)"connection-password", (Object)"password_for_user_from_inline");
        CredentialProvider credentialProvider = this.getCredentialProvider((Map<String, String>)properties);
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(Optional.empty()).get())).isEqualTo("user_from_inline");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(Optional.empty()).get())).isEqualTo("password_for_user_from_inline");
    }

    @Test
    public void testFileCredentialProvider() {
        ImmutableMap properties = ImmutableMap.of((Object)"connection-url", (Object)"jdbc:h2:mem:config", (Object)"credential-provider.type", (Object)"FILE", (Object)"connection-credential-file", (Object)this.getResourceFilePath("credentials.properties"));
        CredentialProvider credentialProvider = this.getCredentialProvider((Map<String, String>)properties);
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(Optional.empty()).get())).isEqualTo("user_from_file");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(Optional.empty()).get())).isEqualTo("password_for_user_from_file");
    }

    @Test
    public void testKeyStoreBasedCredentialProvider() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"connection-url", (Object)"jdbc:h2:mem:config").put((Object)"credential-provider.type", (Object)"KEYSTORE").put((Object)"keystore-file-path", (Object)this.getResourceFilePath("credentials.jceks")).put((Object)"keystore-type", (Object)"JCEKS").put((Object)"keystore-password", (Object)"keystore_password").put((Object)"keystore-user-credential-name", (Object)"userName").put((Object)"keystore-user-credential-password", (Object)"keystore_password_for_user_name").put((Object)"keystore-password-credential-name", (Object)"password").put((Object)"keystore-password-credential-password", (Object)"keystore_password_for_password").buildOrThrow();
        CredentialProvider credentialProvider = this.getCredentialProvider((Map<String, String>)properties);
        Assertions.assertThat((String)((String)credentialProvider.getConnectionUser(Optional.empty()).get())).isEqualTo("user_from_keystore");
        Assertions.assertThat((String)((String)credentialProvider.getConnectionPassword(Optional.empty()).get())).isEqualTo("password_from_keystore");
    }

    private CredentialProvider getCredentialProvider(Map<String, String> properties) {
        return (CredentialProvider)new Bootstrap((Iterable)ImmutableList.of((Object)new CredentialProviderModule())).setOptionalConfigurationProperties(properties).initialize().getInstance(CredentialProvider.class);
    }

    private String getResourceFilePath(String fileName) {
        try {
            return new File(Resources.getResource((String)fileName).toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

