/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.reflect.Reflection;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.RetryingConnectionFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.TestingSession;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.testing.InterfaceTestUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestRetryingConnectionFactory {
    @Test
    public void testEverythingImplemented() {
        InterfaceTestUtils.assertAllMethodsOverridden(ConnectionFactory.class, RetryingConnectionFactory.class);
    }

    @Test
    public void testSimplyReturnConnection() throws Exception {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.RETURN);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        Assertions.assertThat((Object)factory.openConnection(TestingSession.SESSION)).isNotNull();
        Assertions.assertThat((int)mock.getCallCount()).isEqualTo(1);
    }

    @Test
    public void testRetryAndStopOnTrinoException() {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.THROW_TRINO_EXCEPTION);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRetryingConnectionFactory.lambda$testRetryAndStopOnTrinoException$0((ConnectionFactory)factory)).isInstanceOf(TrinoException.class)).hasMessage("Testing Trino exception");
        Assertions.assertThat((int)mock.getCallCount()).isEqualTo(2);
    }

    @Test
    public void testRetryAndStopOnSqlException() {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.THROW_SQL_EXCEPTION);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRetryingConnectionFactory.lambda$testRetryAndStopOnSqlException$1((ConnectionFactory)factory)).isInstanceOf(SQLException.class)).hasMessage("Testing sql exception");
        Assertions.assertThat((int)mock.getCallCount()).isEqualTo(2);
    }

    @Test
    public void testNullPointerException() {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_NPE);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestRetryingConnectionFactory.lambda$testNullPointerException$2((ConnectionFactory)factory)).isInstanceOf(NullPointerException.class)).hasMessage("Testing NPE");
        Assertions.assertThat((int)mock.getCallCount()).isEqualTo(1);
    }

    @Test
    public void testRetryAndReturn() throws Exception {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.RETURN);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        Assertions.assertThat((Object)factory.openConnection(TestingSession.SESSION)).isNotNull();
        Assertions.assertThat((int)mock.getCallCount()).isEqualTo(2);
    }

    @Test
    public void testRetryOnWrappedAndReturn() throws Exception {
        MockConnectorFactory mock = new MockConnectorFactory(MockConnectorFactory.Action.THROW_WRAPPED_SQL_RECOVERABLE_EXCEPTION, MockConnectorFactory.Action.RETURN);
        RetryingConnectionFactory factory = new RetryingConnectionFactory((ConnectionFactory)mock);
        Assertions.assertThat((Object)factory.openConnection(TestingSession.SESSION)).isNotNull();
        Assertions.assertThat((int)mock.getCallCount()).isEqualTo(2);
    }

    private static /* synthetic */ void lambda$testNullPointerException$2(ConnectionFactory factory) throws Throwable {
        factory.openConnection(TestingSession.SESSION);
    }

    private static /* synthetic */ void lambda$testRetryAndStopOnSqlException$1(ConnectionFactory factory) throws Throwable {
        factory.openConnection(TestingSession.SESSION);
    }

    private static /* synthetic */ void lambda$testRetryAndStopOnTrinoException$0(ConnectionFactory factory) throws Throwable {
        factory.openConnection(TestingSession.SESSION);
    }

    public static class MockConnectorFactory
    implements ConnectionFactory {
        private final Deque<Action> actions = new ArrayDeque<Action>();
        private int callCount;

        public MockConnectorFactory(Action ... actions) {
            Stream.of(actions).forEach(this.actions::push);
        }

        public int getCallCount() {
            return this.callCount;
        }

        public Connection openConnection(ConnectorSession session) throws SQLException {
            ++this.callCount;
            Action action = Objects.requireNonNull(this.actions.pollLast(), "actions.pollFirst() is null");
            switch (action) {
                case RETURN: {
                    return (Connection)Reflection.newProxy(Connection.class, (proxy, method, args) -> null);
                }
                case THROW_NPE: {
                    throw new NullPointerException("Testing NPE");
                }
                case THROW_TRINO_EXCEPTION: {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Testing Trino exception");
                }
                case THROW_SQL_EXCEPTION: {
                    throw new SQLException("Testing sql exception");
                }
                case THROW_SQL_RECOVERABLE_EXCEPTION: {
                    throw new SQLRecoverableException("Testing sql recoverable exception");
                }
                case THROW_WRAPPED_SQL_RECOVERABLE_EXCEPTION: {
                    throw new RuntimeException(new SQLRecoverableException("Testing sql recoverable exception"));
                }
            }
            throw new IllegalStateException("Unsupported action:" + action);
        }

        public static enum Action {
            THROW_TRINO_EXCEPTION,
            THROW_SQL_EXCEPTION,
            THROW_SQL_RECOVERABLE_EXCEPTION,
            THROW_WRAPPED_SQL_RECOVERABLE_EXCEPTION,
            THROW_NPE,
            RETURN;

        }
    }
}

