/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.TestingConnectorContext;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJmxStats {
    @Test
    public void testJmxStatsExposure() throws Exception {
        JdbcPlugin plugin = new JdbcPlugin("base_jdbc", (Module)new TestingH2JdbcModule());
        ConnectorFactory factory = (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
        factory.create("test", (Map)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:driver:"), (ConnectorContext)new TestingConnectorContext());
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = mbeanServer.queryNames(new ObjectName("io.trino.plugin.jdbc:*"), null);
        Assertions.assertThat((boolean)objectNames.containsAll((Collection<?>)ImmutableSet.of((Object)new ObjectName("io.trino.plugin.jdbc:type=ConnectionFactory,name=test"), (Object)new ObjectName("io.trino.plugin.jdbc:type=JdbcClient,name=test")))).isTrue();
        for (ObjectName objectName : objectNames) {
            MBeanInfo mbeanInfo = mbeanServer.getMBeanInfo(objectName);
            ((AbstractIntegerAssert)Assertions.assertThat((int)mbeanInfo.getAttributes().length).withFailMessage(String.format("Object %s doesn't expose JMX stats", objectName.getCanonicalName()), new Object[0])).isNotEqualTo(0);
        }
    }
}

