/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.EquivalenceTester;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcRelationHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.MetadataUtil;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.testng.annotations.Test;

public class TestJdbcTableHandle {
    @Test
    public void testJsonRoundTrip() {
        MetadataUtil.assertJsonRoundTrip(MetadataUtil.TABLE_CODEC, new JdbcTableHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchema"), "jdbcTable"), Optional.empty()));
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new JdbcTableHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchema"), "jdbcTable"), Optional.empty()), new Object[]{new JdbcTableHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.of("jdbcCatalogX"), Optional.of("jdbcSchema"), "jdbcTable"), Optional.empty()), new JdbcTableHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchemaX"), "jdbcTable"), Optional.empty()), new JdbcTableHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchema"), "jdbcTableX"), Optional.empty())}).addEquivalentGroup((Object)new JdbcTableHandle(new SchemaTableName("schemaX", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchema"), "jdbcTable"), Optional.empty()), new Object[]{new JdbcTableHandle(new SchemaTableName("schemaX", "table"), new RemoteTableName(Optional.of("jdbcCatalogX"), Optional.of("jdbcSchema"), "jdbcTable"), Optional.empty()), new JdbcTableHandle(new SchemaTableName("schemaX", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchemaX"), "jdbcTable"), Optional.empty()), new JdbcTableHandle(new SchemaTableName("schemaX", "table"), new RemoteTableName(Optional.of("jdbcCatalog"), Optional.of("jdbcSchema"), "jdbcTableX"), Optional.empty())}).addEquivalentGroup((Object)this.createNamedHandle(), new Object[0]).addEquivalentGroup((Object)this.createQueryBasedHandle(), new Object[0]).check();
    }

    private JdbcTableHandle createQueryBasedHandle() {
        JdbcTypeHandle type = new JdbcTypeHandle(4, Optional.of("int"), Optional.of(1), Optional.of(2), Optional.of(3), Optional.of(CaseSensitivity.CASE_INSENSITIVE));
        return new JdbcTableHandle((JdbcRelationHandle)new JdbcQueryRelationHandle(new PreparedQuery("query", (List)ImmutableList.of((Object)new QueryParameter(type, (Type)IntegerType.INTEGER, Optional.of(1))))), TupleDomain.all(), (List)ImmutableList.of(), Optional.empty(), OptionalLong.of(1L), Optional.of(ImmutableList.of((Object)new JdbcColumnHandle("i", type, (Type)IntegerType.INTEGER))), Optional.of(ImmutableSet.of()), 0, Optional.empty(), (List)ImmutableList.of());
    }

    private JdbcTableHandle createNamedHandle() {
        JdbcTypeHandle type = new JdbcTypeHandle(4, Optional.of("int"), Optional.of(1), Optional.of(2), Optional.of(3), Optional.of(CaseSensitivity.CASE_INSENSITIVE));
        return new JdbcTableHandle((JdbcRelationHandle)new JdbcNamedRelationHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.of("catalog"), Optional.of("schema"), "table"), Optional.empty()), TupleDomain.all(), (List)ImmutableList.of(), Optional.empty(), OptionalLong.of(1L), Optional.of(ImmutableList.of((Object)new JdbcColumnHandle("i", type, (Type)IntegerType.INTEGER))), Optional.of(ImmutableSet.of()), 0, Optional.empty(), (List)ImmutableList.of());
    }
}

