/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.json.JsonCodec;
import io.trino.plugin.jdbc.JdbcSplit;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJdbcSplit {
    private final JdbcSplit split = new JdbcSplit(Optional.of("additional predicate"));

    @Test
    public void testAddresses() {
        Assertions.assertThat((List)this.split.getAddresses()).isEmpty();
        Assertions.assertThat((boolean)this.split.isRemotelyAccessible()).isTrue();
        JdbcSplit jdbcSplit = new JdbcSplit(Optional.empty());
        Assertions.assertThat((List)jdbcSplit.getAddresses()).isEmpty();
    }

    @Test
    public void testJsonRoundTrip() {
        JsonCodec codec = JsonCodec.jsonCodec(JdbcSplit.class);
        String json = codec.toJson((Object)this.split);
        JdbcSplit copy = (JdbcSplit)codec.fromJson(json);
        Assertions.assertThat((Optional)copy.getAdditionalPredicate()).isEqualTo((Object)this.split.getAdditionalPredicate());
        Assertions.assertThat((List)copy.getAddresses()).isEmpty();
        Assertions.assertThat((boolean)copy.isRemotelyAccessible()).isTrue();
    }
}

