/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.testing.Closeables;
import io.trino.plugin.jdbc.BaseJdbcConnectorTableHandle;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcRecordSet;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJdbcRecordSet {
    private TestingDatabase database;
    private JdbcClient jdbcClient;
    private JdbcTableHandle table;
    private JdbcSplit split;
    private Map<String, JdbcColumnHandle> columnHandles;
    private ExecutorService executor;

    @BeforeClass
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.jdbcClient = this.database.getJdbcClient();
        this.table = this.database.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
        this.split = this.database.getSplit(TestingConnectorSession.SESSION, this.table);
        this.columnHandles = this.database.getColumnHandles(TestingConnectorSession.SESSION, this.table);
        this.executor = MoreExecutors.newDirectExecutorService();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.database, () -> this.executor.shutdownNow()});
        this.database = null;
        this.executor = null;
    }

    @Test
    public void testGetColumnTypes() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("text_short", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
        Assertions.assertThat((List)recordSet.getColumnTypes()).containsExactly((Object[])new Type[]{VarcharType.VARCHAR, VarcharType.createVarcharType((int)32), BigintType.BIGINT});
        recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)));
        Assertions.assertThat((List)recordSet.getColumnTypes()).containsExactly((Object[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR});
        recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("value", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)));
        Assertions.assertThat((List)recordSet.getColumnTypes()).containsExactly((Object[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR});
        recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of());
        Assertions.assertThat((List)recordSet.getColumnTypes()).isEmpty();
    }

    @Test
    public void testCursorSimple() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("text"), (Object)this.columnHandles.get("text_short"), (Object)this.columnHandles.get("value")));
        try (RecordCursor cursor = recordSet.cursor();){
            Assertions.assertThat((Object)cursor.getType(0)).isEqualTo((Object)VarcharType.VARCHAR);
            Assertions.assertThat((Object)cursor.getType(1)).isEqualTo((Object)VarcharType.createVarcharType((int)32));
            Assertions.assertThat((Object)cursor.getType(2)).isEqualTo((Object)BigintType.BIGINT);
            LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
            while (cursor.advanceNextPosition()) {
                data.put(cursor.getSlice(0).toStringUtf8(), cursor.getLong(2));
                Assertions.assertThat((Comparable)cursor.getSlice(0)).isEqualTo((Object)cursor.getSlice(1));
                Assertions.assertThat((boolean)cursor.isNull(0)).isFalse();
                Assertions.assertThat((boolean)cursor.isNull(1)).isFalse();
                Assertions.assertThat((boolean)cursor.isNull(2)).isFalse();
            }
            Assertions.assertThat(data).isEqualTo((Object)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).buildOrThrow());
            Assertions.assertThat((long)cursor.getReadTimeNanos()).isPositive();
        }
    }

    @Test
    public void testCursorMixedOrder() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        try (RecordCursor cursor = recordSet.cursor();){
            Assertions.assertThat((Object)cursor.getType(0)).isEqualTo((Object)BigintType.BIGINT);
            Assertions.assertThat((Object)cursor.getType(1)).isEqualTo((Object)BigintType.BIGINT);
            Assertions.assertThat((Object)cursor.getType(2)).isEqualTo((Object)VarcharType.VARCHAR);
            LinkedHashMap<String, Long> data = new LinkedHashMap<String, Long>();
            while (cursor.advanceNextPosition()) {
                Assertions.assertThat((long)cursor.getLong(0)).isEqualTo(cursor.getLong(1));
                data.put(cursor.getSlice(2).toStringUtf8(), cursor.getLong(0));
            }
            Assertions.assertThat(data).isEqualTo((Object)ImmutableMap.builder().put((Object)"one", (Object)1L).put((Object)"two", (Object)2L).put((Object)"three", (Object)3L).put((Object)"ten", (Object)10L).put((Object)"eleven", (Object)11L).put((Object)"twelve", (Object)12L).buildOrThrow());
            Assertions.assertThat((long)cursor.getReadTimeNanos()).isPositive();
        }
    }

    @Test
    public void testIdempotentClose() {
        JdbcRecordSet recordSet = this.createRecordSet((List<JdbcColumnHandle>)ImmutableList.of((Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("value"), (Object)this.columnHandles.get("text")));
        RecordCursor cursor = recordSet.cursor();
        cursor.close();
        cursor.close();
    }

    private JdbcRecordSet createRecordSet(List<JdbcColumnHandle> columnHandles) {
        return new JdbcRecordSet(this.jdbcClient, this.executor, TestingConnectorSession.SESSION, this.split, (BaseJdbcConnectorTableHandle)this.table, columnHandles);
    }
}

