/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.testing.EquivalenceTester;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.MetadataUtil;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestJdbcColumnHandle {
    @Test
    public void testJsonRoundTrip() {
        MetadataUtil.assertJsonRoundTrip(MetadataUtil.COLUMN_CODEC, JdbcColumnHandle.builder().setColumnName("columnName").setJdbcTypeHandle(TestingJdbcTypeHandle.JDBC_VARCHAR).setColumnType((Type)VarcharType.VARCHAR).setComment(Optional.of("some comment")).build());
    }

    @Test
    public void testEquivalence() {
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)new JdbcColumnHandle("columnName", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), new Object[]{new JdbcColumnHandle("columnName", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), new JdbcColumnHandle("columnName", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), new JdbcColumnHandle("columnName", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)}).addEquivalentGroup((Object)new JdbcColumnHandle("columnNameX", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), new Object[]{new JdbcColumnHandle("columnNameX", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), new JdbcColumnHandle("columnNameX", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), new JdbcColumnHandle("columnNameX", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)}).check();
    }
}

