/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import jakarta.validation.constraints.AssertTrue;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestBaseJdbcConfig {
    private static final Duration ZERO = Duration.succinctDuration((double)0.0, (TimeUnit)TimeUnit.MINUTES);

    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((BaseJdbcConfig)ConfigAssertions.recordDefaults(BaseJdbcConfig.class)).setConnectionUrl(null).setJdbcTypesMappedToVarchar("").setMetadataCacheTtl(ZERO).setSchemaNamesCacheTtl(null).setTableNamesCacheTtl(null).setCacheMissing(false).setCacheMaximumSize(10000L));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"connection-url", (Object)"jdbc:h2:mem:config").put((Object)"jdbc-types-mapped-to-varchar", (Object)"mytype,struct_type1").put((Object)"metadata.cache-ttl", (Object)"1s").put((Object)"metadata.schemas.cache-ttl", (Object)"2s").put((Object)"metadata.tables.cache-ttl", (Object)"3s").put((Object)"metadata.cache-missing", (Object)"true").put((Object)"metadata.cache-maximum-size", (Object)"5000").buildOrThrow();
        BaseJdbcConfig expected = new BaseJdbcConfig().setConnectionUrl("jdbc:h2:mem:config").setJdbcTypesMappedToVarchar("mytype, struct_type1").setMetadataCacheTtl(new Duration(1.0, TimeUnit.SECONDS)).setSchemaNamesCacheTtl(new Duration(2.0, TimeUnit.SECONDS)).setTableNamesCacheTtl(new Duration(3.0, TimeUnit.SECONDS)).setCacheMissing(true).setCacheMaximumSize(5000L);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
        Assertions.assertThat((Collection)expected.getJdbcTypesMappedToVarchar()).containsOnly((Object[])new String[]{"mytype", "struct_type1"});
    }

    @Test
    public void testConnectionUrlIsValid() {
        Assertions.assertThatThrownBy(() -> TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:"))).hasMessageContaining("must match \"^jdbc:[a-z0-9]+:(?s:.*)$\"");
        Assertions.assertThatThrownBy(() -> TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:protocol"))).hasMessageContaining("must match \"^jdbc:[a-z0-9]+:(?s:.*)$\"");
        TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:protocol:uri"));
        TestBaseJdbcConfig.buildConfig((Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)"jdbc:protocol:"));
    }

    @Test
    public void testCacheConfigValidation() {
        ValidationAssertions.assertValidates((Object)new BaseJdbcConfig().setConnectionUrl("jdbc:h2:mem:config").setMetadataCacheTtl(new Duration(1.0, TimeUnit.SECONDS)).setSchemaNamesCacheTtl(new Duration(2.0, TimeUnit.SECONDS)).setTableNamesCacheTtl(new Duration(3.0, TimeUnit.SECONDS)).setCacheMaximumSize(5000L));
        ValidationAssertions.assertValidates((Object)new BaseJdbcConfig().setConnectionUrl("jdbc:h2:mem:config").setMetadataCacheTtl(new Duration(1.0, TimeUnit.SECONDS)));
        ValidationAssertions.assertFailsValidation((Object)new BaseJdbcConfig().setCacheMaximumSize(5000L), (String)"cacheMaximumSizeConsistent", (String)"metadata.cache-ttl must be set to a non-zero value when metadata.cache-maximum-size is set", AssertTrue.class);
        ValidationAssertions.assertFailsValidation((Object)new BaseJdbcConfig().setSchemaNamesCacheTtl(new Duration(1.0, TimeUnit.SECONDS)), (String)"schemaNamesCacheTtlConsistent", (String)"metadata.schemas.cache-ttl must not be set when metadata.cache-ttl is not set", AssertTrue.class);
        ValidationAssertions.assertFailsValidation((Object)new BaseJdbcConfig().setTableNamesCacheTtl(new Duration(1.0, TimeUnit.SECONDS)), (String)"tableNamesCacheTtlConsistent", (String)"metadata.tables.cache-ttl must not be set when metadata.cache-ttl is not set", AssertTrue.class);
    }

    private static void buildConfig(Map<String, String> properties) {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(properties);
        configurationFactory.build(BaseJdbcConfig.class);
    }
}

