/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class RemoteDatabaseEvent {
    private final String query;
    private final Status status;

    public RemoteDatabaseEvent(String query, Status status) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.status = Objects.requireNonNull(status, "status is null");
    }

    public String getQuery() {
        return this.query;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteDatabaseEvent that = (RemoteDatabaseEvent)o;
        return this.query.equals(that.query) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("query", (Object)this.query).add("status", (Object)this.status).toString();
    }

    public static enum Status {
        RUNNING,
        CANCELLED,
        DONE;

    }
}

