/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.common;

import io.trino.hive.$internal.com.google.common.cache.Cache;
import io.trino.hive.$internal.com.google.common.cache.CacheBuilder;
import io.trino.hive.$internal.com.google.common.cache.RemovalListener;
import io.trino.hive.$internal.com.google.common.cache.RemovalNotification;
import io.trino.hive.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.trino.hive.$internal.org.apache.commons.lang.builder.EqualsBuilder;
import io.trino.hive.$internal.org.apache.commons.lang.builder.HashCodeBuilder;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.NoReconnect;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.thrift.TException;

class HiveClientCache {
    public static final int DEFAULT_HIVE_CACHE_EXPIRY_TIME_SECONDS = 120;
    public static final int DEFAULT_HIVE_CACHE_INITIAL_CAPACITY = 50;
    public static final int DEFAULT_HIVE_CACHE_MAX_CAPACITY = 50;
    public static final boolean DEFAULT_HIVE_CLIENT_CACHE_STATS_ENABLED = false;
    private final Cache<HiveClientCacheKey, ICacheableMetaStoreClient> hiveCache;
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientCache.class);
    private final int timeout;
    private final Object CACHE_TEARDOWN_LOCK = new Object();
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final ScheduledFuture<?> cleanupHandle;
    private boolean enableStats;
    private static final ThreadLocal<Integer> threadId = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return nextId.getAndIncrement();
        }
    };

    private int getThreadId() {
        return threadId.get();
    }

    public static IMetaStoreClient getNonCachedHiveMetastoreClient(HiveConf hiveConf) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, true);
    }

    public HiveClientCache(HiveConf hiveConf) {
        this(hiveConf.getInt("hcatalog.hive.client.cache.expiry.time", 120), hiveConf.getInt("hcatalog.hive.client.cache.initial.capacity", 50), hiveConf.getInt("hcatalog.hive.client.cache.max.capacity", 50), hiveConf.getBoolean("hcatalog.hive.client.cache.stats.enabled", false));
    }

    @Deprecated
    public HiveClientCache(int timeout) {
        this(timeout, 50, 50, false);
    }

    private HiveClientCache(int timeout, int initialCapacity, int maxCapacity, boolean enableStats) {
        this.timeout = timeout;
        this.enableStats = enableStats;
        LOG.info("Initializing cache: eviction-timeout=" + timeout + " initial-capacity=" + initialCapacity + " maximum-capacity=" + maxCapacity);
        CacheBuilder<HiveClientCacheKey, ICacheableMetaStoreClient> builder = CacheBuilder.newBuilder().initialCapacity(initialCapacity).maximumSize(maxCapacity).expireAfterAccess(timeout, TimeUnit.SECONDS).removalListener(this.createRemovalListener());
        try {
            Method m = builder.getClass().getMethod("recordStats", null);
            m.invoke(builder, null);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Using a version of guava <12.0. Stats collection is enabled by default.");
        }
        catch (Exception e) {
            LOG.warn("Unable to invoke recordStats method.", e);
        }
        this.hiveCache = builder.build();
        long cleanupInterval = timeout > 120 ? (long)timeout : 120L;
        this.cleanupHandle = this.createCleanupThread(cleanupInterval);
        this.createShutdownHook();
    }

    private RemovalListener<HiveClientCacheKey, ICacheableMetaStoreClient> createRemovalListener() {
        RemovalListener<HiveClientCacheKey, ICacheableMetaStoreClient> listener = new RemovalListener<HiveClientCacheKey, ICacheableMetaStoreClient>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoval(RemovalNotification<HiveClientCacheKey, ICacheableMetaStoreClient> notification) {
                ICacheableMetaStoreClient hiveMetaStoreClient = notification.getValue();
                if (hiveMetaStoreClient != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Evicting client: " + Integer.toHexString(System.identityHashCode(hiveMetaStoreClient)));
                    }
                    Object object = HiveClientCache.this.CACHE_TEARDOWN_LOCK;
                    synchronized (object) {
                        hiveMetaStoreClient.setExpiredFromCache();
                        hiveMetaStoreClient.tearDownIfUnused();
                    }
                }
            }
        };
        return listener;
    }

    private ScheduledFuture<?> createCleanupThread(long interval) {
        Runnable cleanupThread = new Runnable(){

            @Override
            public void run() {
                HiveClientCache.this.cleanup();
            }
        };
        ThreadFactory daemonThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HiveClientCache-cleaner-%d").build();
        return Executors.newScheduledThreadPool(1, daemonThreadFactory).scheduleWithFixedDelay(cleanupThread, this.timeout + 5, interval, TimeUnit.SECONDS);
    }

    private void createShutdownHook() {
        Thread cleanupHiveClientShutdownThread = new Thread(){

            @Override
            public void run() {
                LOG.debug("Cleaning up hive client cache in ShutDown hook");
                HiveClientCache.this.cleanupHandle.cancel(false);
                HiveClientCache.this.closeAllClientsQuietly();
            }
        };
        ShutdownHookManager.addShutdownHook(cleanupHiveClientShutdownThread);
    }

    void closeAllClientsQuietly() {
        try {
            ConcurrentMap<HiveClientCacheKey, ICacheableMetaStoreClient> elements = this.hiveCache.asMap();
            for (ICacheableMetaStoreClient cacheableHiveMetaStoreClient : elements.values()) {
                cacheableHiveMetaStoreClient.tearDown();
            }
        }
        catch (Exception e) {
            LOG.warn("Clean up of hive clients in the cache failed. Ignored", e);
        }
        if (this.enableStats) {
            LOG.info("Cache statistics after shutdown: size=" + this.hiveCache.size() + " " + this.hiveCache.stats());
        }
    }

    public void cleanup() {
        this.hiveCache.cleanUp();
        if (this.enableStats) {
            LOG.info("Cache statistics after cleanup: size=" + this.hiveCache.size() + " " + this.hiveCache.stats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetaStoreClient get(HiveConf hiveConf) throws MetaException, IOException, LoginException {
        HiveClientCacheKey cacheKey = HiveClientCacheKey.fromHiveConf(hiveConf, this.getThreadId());
        ICacheableMetaStoreClient cacheableHiveMetaStoreClient = null;
        Object object = this.CACHE_TEARDOWN_LOCK;
        synchronized (object) {
            cacheableHiveMetaStoreClient = this.getOrCreate(cacheKey);
            cacheableHiveMetaStoreClient.acquire();
        }
        if (!cacheableHiveMetaStoreClient.isOpen()) {
            object = this.CACHE_TEARDOWN_LOCK;
            synchronized (object) {
                this.hiveCache.invalidate(cacheKey);
                cacheableHiveMetaStoreClient.close();
                cacheableHiveMetaStoreClient = this.getOrCreate(cacheKey);
                cacheableHiveMetaStoreClient.acquire();
            }
        }
        return cacheableHiveMetaStoreClient;
    }

    private ICacheableMetaStoreClient getOrCreate(final HiveClientCacheKey cacheKey) throws IOException, MetaException, LoginException {
        try {
            return this.hiveCache.get(cacheKey, new Callable<ICacheableMetaStoreClient>(){

                @Override
                public ICacheableMetaStoreClient call() throws MetaException {
                    return (ICacheableMetaStoreClient)RetryingMetaStoreClient.getProxy(cacheKey.getHiveConf(), new Class[]{HiveConf.class, Integer.class, Boolean.class}, new Object[]{cacheKey.getHiveConf(), HiveClientCache.this.timeout, true}, CacheableHiveMetaStoreClient.class.getName());
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof MetaException) {
                throw (MetaException)((Object)t);
            }
            if (t instanceof LoginException) {
                throw (LoginException)t;
            }
            throw new IOException("Error creating hiveMetaStoreClient", t);
        }
    }

    static class CacheableHiveMetaStoreClient
    extends HiveMetaStoreClient
    implements ICacheableMetaStoreClient {
        private final AtomicInteger users = new AtomicInteger(0);
        private volatile boolean expiredFromCache = false;
        private boolean isClosed = false;

        CacheableHiveMetaStoreClient(HiveConf conf, Integer timeout, Boolean allowEmbedded) throws MetaException {
            super(conf, null, allowEmbedded);
        }

        @Override
        public synchronized void acquire() {
            this.users.incrementAndGet();
            if (this.users.get() > 1) {
                LOG.warn("Unexpected increment of user count beyond one: " + this.users.get() + " " + this);
            }
        }

        private void release() {
            if (this.users.get() > 0) {
                this.users.decrementAndGet();
            } else {
                LOG.warn("Unexpected attempt to decrement user count of zero: " + this.users.get() + " " + this);
            }
        }

        @Override
        public synchronized void setExpiredFromCache() {
            if (this.users.get() != 0) {
                LOG.warn("Evicted client has non-zero user count: " + this.users.get());
            }
            this.expiredFromCache = true;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public AtomicInteger getUsers() {
            return this.users;
        }

        @Override
        @Deprecated
        public boolean isOpen() {
            try {
                super.getDatabases("NonExistentDatabaseUsedForHealthCheck");
            }
            catch (TException e) {
                return false;
            }
            return true;
        }

        @Override
        public synchronized void close() {
            this.release();
            this.tearDownIfUnused();
        }

        @Override
        public synchronized void tearDownIfUnused() {
            if (this.users.get() != 0) {
                LOG.warn("Non-zero user count preventing client tear down: users=" + this.users.get() + " expired=" + this.expiredFromCache);
            }
            if (this.users.get() == 0 && this.expiredFromCache) {
                this.tearDown();
            }
        }

        @Override
        public void tearDown() {
            try {
                if (!this.isClosed) {
                    super.close();
                }
                this.isClosed = true;
            }
            catch (Exception e) {
                LOG.warn("Error closing hive metastore client. Ignored.", e);
            }
        }

        public String toString() {
            return "HCatClient: thread: " + Thread.currentThread().getId() + " users=" + this.users.get() + " expired=" + this.expiredFromCache + " closed=" + this.isClosed;
        }

        protected void finalize() throws Throwable {
            if (this.users.get() != 0) {
                LOG.warn("Closing client with non-zero user count: users=" + this.users.get() + " expired=" + this.expiredFromCache);
            }
            try {
                this.tearDown();
            }
            finally {
                super.finalize();
            }
        }
    }

    @InterfaceAudience.Private
    public static interface ICacheableMetaStoreClient
    extends IMetaStoreClient {
        @NoReconnect
        public void acquire();

        @NoReconnect
        public void setExpiredFromCache();

        @NoReconnect
        public AtomicInteger getUsers();

        @NoReconnect
        public boolean isClosed();

        @Deprecated
        @NoReconnect
        public boolean isOpen();

        @NoReconnect
        public void tearDownIfUnused();

        @NoReconnect
        public void tearDown();
    }

    static class HiveClientCacheKey {
        private final String metaStoreURIs;
        private final UserGroupInformation ugi;
        private final HiveConf hiveConf;
        private final int threadId;

        private HiveClientCacheKey(HiveConf hiveConf, int threadId) throws IOException, LoginException {
            this.metaStoreURIs = hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
            this.ugi = Utils.getUGI();
            this.hiveConf = hiveConf;
            this.threadId = threadId;
        }

        public static HiveClientCacheKey fromHiveConf(HiveConf hiveConf, int threadId) throws IOException, LoginException {
            return new HiveClientCacheKey(hiveConf, threadId);
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveClientCacheKey that = (HiveClientCacheKey)o;
            return new EqualsBuilder().append(this.metaStoreURIs, that.metaStoreURIs).append(this.ugi, that.ugi).append(this.threadId, that.threadId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.metaStoreURIs).append(this.ugi).append(this.threadId).toHashCode();
        }

        public String toString() {
            return "HiveClientCacheKey: uri=" + this.metaStoreURIs + " ugi=" + this.ugi + " thread=" + this.threadId;
        }
    }
}

