/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.io.LongWritable;

public class GenericUDFEpochMilli
extends GenericUDF {
    private final transient LongWritable result = new LongWritable();
    private transient TimestampLocalTZObjectInspector oi;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The operator GenericUDFEpochMilli only accepts 1 argument.");
        }
        this.oi = (TimestampLocalTZObjectInspector)arguments[0];
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object a0 = arguments[0].get();
        if (a0 == null) {
            return null;
        }
        this.result.set(this.oi.getPrimitiveJavaObject(a0).getZonedDateTime().toInstant().toEpochMilli());
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "GenericUDFEpochMilli(" + children[0] + ")";
    }
}

