/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class AlterPartitionHandler
extends AbstractEventHandler {
    private final Partition after;
    private final org.apache.hadoop.hive.metastore.api.Table tableObject;
    private final boolean isTruncateOp;
    private final Scenario scenario;

    AlterPartitionHandler(NotificationEvent event) throws Exception {
        super(event);
        AlterPartitionMessage apm = this.deserializer.getAlterPartitionMessage(event.getMessage());
        this.tableObject = apm.getTableObj();
        Partition before = apm.getPtnObjBefore();
        this.after = apm.getPtnObjAfter();
        this.isTruncateOp = apm.getIsTruncateOp();
        this.scenario = this.scenarioType(before, this.after);
    }

    private Scenario scenarioType(Partition before, Partition after) {
        Iterator<String> beforeValIter = before.getValuesIterator();
        Iterator<String> afterValIter = after.getValuesIterator();
        while (beforeValIter.hasNext()) {
            if (beforeValIter.next().equals(afterValIter.next())) continue;
            return Scenario.RENAME;
        }
        return this.isTruncateOp ? Scenario.TRUNCATE : Scenario.ALTER;
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} ALTER_PARTITION message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        Table qlMdTable = new Table(this.tableObject);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, withinContext.hiveConf).booleanValue()) {
            return;
        }
        if (Scenario.ALTER == this.scenario) {
            withinContext.replicationSpec.setIsMetadataOnly(true);
            ArrayList<org.apache.hadoop.hive.ql.metadata.Partition> partitions = new ArrayList<org.apache.hadoop.hive.ql.metadata.Partition>();
            partitions.add(new org.apache.hadoop.hive.ql.metadata.Partition(qlMdTable, this.after));
            Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
            EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, partitions, withinContext.replicationSpec, withinContext.hiveConf);
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.event.getMessage());
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return this.scenario.dumpType();
    }

    private static enum Scenario {
        ALTER{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_ALTER_PARTITION;
            }
        }
        ,
        RENAME{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_RENAME_PARTITION;
            }
        }
        ,
        TRUNCATE{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_TRUNCATE_PARTITION;
            }
        };


        abstract DumpType dumpType();
    }
}

