/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import io.trino.hive.$internal.com.google.common.collect.ImmutableList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveFilterSortTransposeRule
extends RelOptRule {
    public static final HiveFilterSortTransposeRule INSTANCE = new HiveFilterSortTransposeRule();

    private HiveFilterSortTransposeRule() {
        super(HiveFilterSortTransposeRule.operand(HiveFilter.class, (RelOptRuleOperand)HiveFilterSortTransposeRule.operand(HiveSortLimit.class, (RelOptRuleOperandChildren)HiveFilterSortTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveSortLimit sort = (HiveSortLimit)call.rel(1);
        return !HiveCalciteUtil.limitRelNode(sort);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveFilter filter = (HiveFilter)call.rel(0);
        HiveSortLimit sort = (HiveSortLimit)call.rel(1);
        RelNode newFilter = filter.copy(sort.getInput().getTraitSet(), ImmutableList.of(sort.getInput()));
        HiveSortLimit newSort = sort.copy(sort.getTraitSet(), newFilter, sort.collation, sort.offset, sort.fetch);
        call.transformTo((RelNode)newSort);
    }
}

