/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public enum ETypeConverter {
    EDOUBLE_CONVERTER((Class)Double.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                public void addDouble(double value) {
                    parent.set(index, (Writable)new DoubleWritable(value));
                }
            };
        }
    }
    ,
    EBOOLEAN_CONVERTER((Class)Boolean.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                public void addBoolean(boolean value) {
                    parent.set(index, (Writable)new BooleanWritable(value));
                }
            };
        }
    }
    ,
    EFLOAT_CONVERTER((Class)Float.TYPE){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null && hiveTypeInfo.equals(TypeInfoFactory.doubleTypeInfo)) {
                return new PrimitiveConverter(){

                    public void addFloat(float value) {
                        parent.set(index, (Writable)new DoubleWritable(value));
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addFloat(float value) {
                    parent.set(index, (Writable)new FloatWritable(value));
                }
            };
        }
    }
    ,
    EINT32_CONVERTER((Class)Integer.TYPE){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final long minValue = ETypeConverter.getMinValue(type, typeName, Integer.MIN_VALUE);
                final long maxValue = ETypeConverter.getMaxValue(typeName, Integer.MAX_VALUE);
                switch (typeName) {
                    case "bigint": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new LongWritable((long)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "float": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)new DoubleWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue) {
                                    parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale(new HiveDecimalWritable(value), (DecimalTypeInfo)hiveTypeInfo));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue && (long)value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addInt(int value) {
                                if ((long)value >= minValue && (long)value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    public void addInt(int value) {
                        if ((long)value >= minValue && (long)value <= maxValue) {
                            parent.set(index, (Writable)new IntWritable(value));
                        } else {
                            parent.set(index, null);
                        }
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    if (value >= (OriginalType.UINT_8 == type.getOriginalType() || OriginalType.UINT_16 == type.getOriginalType() || OriginalType.UINT_32 == type.getOriginalType() || OriginalType.UINT_64 == type.getOriginalType() ? 0 : Integer.MIN_VALUE)) {
                        parent.set(index, (Writable)new IntWritable(value));
                    } else {
                        parent.set(index, null);
                    }
                }
            };
        }
    }
    ,
    EINT64_CONVERTER((Class)Long.TYPE){

        @Override
        PrimitiveConverter getConverter(final PrimitiveType type, final int index, final ConverterParent parent, final TypeInfo hiveTypeInfo) {
            if (hiveTypeInfo != null) {
                String typeName = TypeInfoUtils.getBaseName(hiveTypeInfo.getTypeName());
                final long minValue = ETypeConverter.getMinValue(type, typeName, Long.MIN_VALUE);
                final long maxValue = ETypeConverter.getMaxValue(typeName, Long.MAX_VALUE);
                switch (typeName) {
                    case "float": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)new FloatWritable((float)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "double": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)new DoubleWritable(value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "decimal": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue) {
                                    parent.set(index, (Writable)HiveDecimalUtils.enforcePrecisionScale(new HiveDecimalWritable(value), (DecimalTypeInfo)hiveTypeInfo));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "int": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "smallint": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                    case "tinyint": {
                        return new PrimitiveConverter(){

                            public void addLong(long value) {
                                if (value >= minValue && value <= maxValue) {
                                    parent.set(index, (Writable)new IntWritable((int)value));
                                } else {
                                    parent.set(index, null);
                                }
                            }
                        };
                    }
                }
                return new PrimitiveConverter(){

                    public void addLong(long value) {
                        if (value >= minValue) {
                            parent.set(index, (Writable)new LongWritable(value));
                        } else {
                            parent.set(index, null);
                        }
                    }
                };
            }
            return new PrimitiveConverter(){

                public void addLong(long value) {
                    if (value >= (OriginalType.UINT_8 == type.getOriginalType() || OriginalType.UINT_16 == type.getOriginalType() || OriginalType.UINT_32 == type.getOriginalType() || OriginalType.UINT_64 == type.getOriginalType() ? 0L : Long.MIN_VALUE)) {
                        parent.set(index, (Writable)new LongWritable(value));
                    } else {
                        parent.set(index, null);
                    }
                }
            };
        }
    }
    ,
    EBINARY_CONVERTER((Class)Binary.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<BytesWritable>(type, parent, index){

                @Override
                protected BytesWritable convert(Binary binary) {
                    return new BytesWritable(binary.getBytes());
                }
            };
        }
    }
    ,
    ESTRING_CONVERTER((Class)String.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<Text>(type, parent, index){

                @Override
                protected Text convert(Binary binary) {
                    return new Text(binary.getBytes());
                }
            };
        }
    }
    ,
    EDECIMAL_CONVERTER((Class)BigDecimal.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<HiveDecimalWritable>(type, parent, index){

                @Override
                protected HiveDecimalWritable convert(Binary binary) {
                    return new HiveDecimalWritable(binary.getBytes(), this.type.getDecimalMetadata().getScale());
                }
            };
        }
    }
    ,
    ETIMESTAMP_CONVERTER((Class)TimestampWritableV2.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new BinaryConverter<TimestampWritableV2>(type, parent, index){

                @Override
                protected TimestampWritableV2 convert(Binary binary) {
                    NanoTime nt = NanoTime.fromBinary(binary);
                    Map<String, String> metadata = parent.getMetadata();
                    boolean skipConversion = Boolean.parseBoolean(metadata.get(HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname));
                    Timestamp ts = NanoTimeUtils.getTimestamp((NanoTime)nt, (boolean)skipConversion, (ZoneId)DataWritableReadSupport.getWriterTimeZoneId(metadata));
                    return new TimestampWritableV2(ts);
                }
            };
        }
    }
    ,
    EDATE_CONVERTER((Class)DateWritableV2.class){

        @Override
        PrimitiveConverter getConverter(PrimitiveType type, final int index, final ConverterParent parent, TypeInfo hiveTypeInfo) {
            return new PrimitiveConverter(){

                public void addInt(int value) {
                    parent.set(index, (Writable)new DateWritableV2(value));
                }
            };
        }
    };

    final Class<?> _type;

    private ETypeConverter(Class<?> type) {
        this._type = type;
    }

    private Class<?> getType() {
        return this._type;
    }

    abstract PrimitiveConverter getConverter(PrimitiveType var1, int var2, ConverterParent var3, TypeInfo var4);

    public static PrimitiveConverter getNewConverter(PrimitiveType type, int index, ConverterParent parent, TypeInfo hiveTypeInfo) {
        if (type.isPrimitive() && type.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
            return ETIMESTAMP_CONVERTER.getConverter(type, index, parent, hiveTypeInfo);
        }
        if (OriginalType.DECIMAL == type.getOriginalType()) {
            return EDECIMAL_CONVERTER.getConverter(type, index, parent, hiveTypeInfo);
        }
        if (OriginalType.UTF8 == type.getOriginalType()) {
            return ESTRING_CONVERTER.getConverter(type, index, parent, hiveTypeInfo);
        }
        if (OriginalType.DATE == type.getOriginalType()) {
            return EDATE_CONVERTER.getConverter(type, index, parent, hiveTypeInfo);
        }
        Class javaType = type.getPrimitiveTypeName().javaType;
        for (ETypeConverter eConverter : ETypeConverter.values()) {
            if (eConverter.getType() != javaType) continue;
            return eConverter.getConverter(type, index, parent, hiveTypeInfo);
        }
        throw new IllegalArgumentException("Converter not found ... for type : " + type);
    }

    private static long getMinValue(PrimitiveType type, String typeName, long defaultValue) {
        if (OriginalType.UINT_8 == type.getOriginalType() || OriginalType.UINT_16 == type.getOriginalType() || OriginalType.UINT_32 == type.getOriginalType() || OriginalType.UINT_64 == type.getOriginalType()) {
            return 0L;
        }
        switch (typeName) {
            case "int": {
                return Integer.MIN_VALUE;
            }
            case "smallint": {
                return -32768L;
            }
            case "tinyint": {
                return -128L;
            }
        }
        return defaultValue;
    }

    private static long getMaxValue(String typeName, long defaultValue) {
        switch (typeName) {
            case "int": {
                return Integer.MAX_VALUE;
            }
            case "smallint": {
                return 32767L;
            }
            case "tinyint": {
                return 127L;
            }
        }
        return defaultValue;
    }

    public static abstract class BinaryConverter<T extends Writable>
    extends PrimitiveConverter {
        protected final PrimitiveType type;
        private final ConverterParent parent;
        private final int index;
        private ArrayList<T> lookupTable;

        public BinaryConverter(PrimitiveType type, ConverterParent parent, int index) {
            this.type = type;
            this.parent = parent;
            this.index = index;
        }

        protected abstract T convert(Binary var1);

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            int length = dictionary.getMaxId() + 1;
            this.lookupTable = new ArrayList();
            for (int i = 0; i < length; ++i) {
                this.lookupTable.add(this.convert(dictionary.decodeToBinary(i)));
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.set(this.index, (Writable)this.lookupTable.get(dictionaryId));
        }

        public void addBinary(Binary value) {
            this.parent.set(this.index, (Writable)this.convert(value));
        }
    }
}

