/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.trino.hive.$internal.com.google.common.base.Preconditions;
import io.trino.hive.$internal.org.apache.commons.logging.Log;
import io.trino.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongLastValue
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorLongLastValue.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean isGroupResultNull;
    protected long lastValue;

    public VectorPTFEvaluatorLongLastValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        if (!isLastGroupBatch) {
            return;
        }
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                this.lastValue = longColVector.vector[0];
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        } else if (longColVector.noNulls) {
            this.lastValue = longColVector.vector[size - 1];
            this.isGroupResultNull = false;
        } else {
            int lastBatchIndex = size - 1;
            if (!longColVector.isNull[lastBatchIndex]) {
                this.lastValue = longColVector.vector[lastBatchIndex];
                this.isGroupResultNull = false;
            } else {
                this.isGroupResultNull = true;
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public long getLongGroupResult() {
        return this.lastValue;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.lastValue = 0L;
    }
}

