/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalUtil {
    public static int compare(HiveDecimalWritable writableLeft, HiveDecimal right) {
        return writableLeft.getHiveDecimal().compareTo(right);
    }

    public static int compare(HiveDecimal left, HiveDecimalWritable writableRight) {
        return HiveDecimalWritable.compareTo(left, writableRight);
    }

    public static void addChecked(int i, HiveDecimal left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateAdd(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void addChecked(int i, HiveDecimalWritable left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateAdd(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void addChecked(int i, HiveDecimalWritable left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateAdd(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void addChecked(int i, HiveDecimal left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateAdd(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void subtractChecked(int i, HiveDecimal left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateSubtract(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void subtractChecked(int i, HiveDecimalWritable left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateSubtract(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void subtractChecked(int i, HiveDecimalWritable left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateSubtract(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void subtractChecked(int i, HiveDecimal left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateSubtract(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void multiplyChecked(int i, HiveDecimal left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateMultiply(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void multiplyChecked(int i, HiveDecimalWritable left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateMultiply(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void multiplyChecked(int i, HiveDecimalWritable left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateMultiply(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void multiplyChecked(int i, HiveDecimal left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateMultiply(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void divideChecked(int i, HiveDecimal left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateDivide(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void divideChecked(int i, HiveDecimalWritable left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateDivide(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void divideChecked(int i, HiveDecimalWritable left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateDivide(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void divideChecked(int i, HiveDecimal left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateDivide(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void moduloChecked(int i, HiveDecimal left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateRemainder(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void moduloChecked(int i, HiveDecimalWritable left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateRemainder(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void moduloChecked(int i, HiveDecimalWritable left, HiveDecimal right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateRemainder(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void moduloChecked(int i, HiveDecimal left, HiveDecimalWritable right, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(left);
        decWritable.mutateRemainder(right);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void floor(int i, HiveDecimal input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(0, 3);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void floor(int i, HiveDecimalWritable input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(0, 3);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void ceiling(int i, HiveDecimal input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(0, 2);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void ceiling(int i, HiveDecimalWritable input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(0, 2);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void round(int i, HiveDecimal input, int decimalPlaces, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(decimalPlaces, 4);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void round(int i, HiveDecimalWritable input, int decimalPlaces, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(decimalPlaces, 4);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void round(int i, HiveDecimal input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(outputColVector.scale, 4);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void round(int i, HiveDecimalWritable input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(outputColVector.scale, 4);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void bround(int i, HiveDecimalWritable input, int decimalPlaces, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(decimalPlaces, 6);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void bround(int i, HiveDecimalWritable input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateSetScale(outputColVector.scale, 6);
        decWritable.mutateEnforcePrecisionScale(outputColVector.precision, outputColVector.scale);
        if (!decWritable.isSet()) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void sign(int i, HiveDecimal input, LongColumnVector outputColVector) {
        outputColVector.vector[i] = input.signum();
    }

    public static void sign(int i, HiveDecimalWritable input, LongColumnVector outputColVector) {
        outputColVector.vector[i] = input.signum();
    }

    public static void abs(int i, HiveDecimal input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateAbs();
    }

    public static void abs(int i, HiveDecimalWritable input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateAbs();
    }

    public static void negate(int i, HiveDecimal input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateNegate();
    }

    public static void negate(int i, HiveDecimalWritable input, DecimalColumnVector outputColVector) {
        HiveDecimalWritable decWritable = outputColVector.vector[i];
        decWritable.set(input);
        decWritable.mutateNegate();
    }
}

