/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.util.StringUtils;

class CompactionTxnHandler
extends TxnHandler {
    private static final String CLASS_NAME = CompactionTxnHandler.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(CLASS_NAME);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int maxAborted) throws MetaException {
        Connection dbConn = null;
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                CompactionInfo info;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select distinct ctc_database, ctc_table, ctc_partition from COMPLETED_TXN_COMPONENTS";
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                while (rs.next()) {
                    info = new CompactionInfo();
                    info.dbname = rs.getString(1);
                    info.tableName = rs.getString(2);
                    info.partName = rs.getString(3);
                    response.add(info);
                }
                rs.close();
                s = "select tc_database, tc_table, tc_partition from TXNS, TXN_COMPONENTS where txn_id = tc_txnid and txn_state = 'a' group by tc_database, tc_table, tc_partition having count(*) > " + maxAborted;
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                while (rs.next()) {
                    info = new CompactionInfo();
                    info.dbname = rs.getString(1);
                    info.tableName = rs.getString(2);
                    info.partName = rs.getString(3);
                    info.tooManyAborts = true;
                    response.add(info);
                }
                LOG.debug("Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to connect to transaction database " + e.getMessage());
                    this.checkRetryable(dbConn, e, "findPotentialCompactions(maxAborted:" + maxAborted + ")");
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
                CompactionTxnHandler.close(rs, stmt, dbConn);
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
            return response;
        }
        catch (TxnHandler.RetryException e) {
            return this.findPotentialCompactions(maxAborted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.Idempotent
    public void setRunAs(long cq_id, String user) throws MetaException {
        block7: {
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    String s = "update COMPACTION_QUEUE set cq_run_as = '" + user + "' where cq_id = " + cq_id;
                    LOG.debug("Going to execute update <" + s + ">");
                    int updCnt = stmt.executeUpdate(s);
                    if (updCnt != 1) {
                        LOG.error("Unable to set cq_run_as=" + user + " for compaction record with cq_id=" + cq_id + ".  updCnt=" + updCnt);
                        LOG.debug("Going to rollback");
                        dbConn.rollback();
                    }
                    LOG.debug("Going to commit");
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.error("Unable to update compaction queue, " + e.getMessage());
                        LOG.debug("Going to rollback");
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(dbConn, e, "setRunAs(cq_id:" + cq_id + ",user:" + user + ")");
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.closeDbConn(dbConn);
                        CompactionTxnHandler.closeStmt(stmt);
                        throw throwable;
                    }
                    CompactionTxnHandler.closeDbConn(dbConn);
                    CompactionTxnHandler.closeStmt(stmt);
                    break block7;
                }
                CompactionTxnHandler.closeDbConn(dbConn);
                CompactionTxnHandler.closeStmt(stmt);
            }
            catch (TxnHandler.RetryException e) {
                this.setRunAs(cq_id, user);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.SafeToRetry
    public CompactionInfo findNextToCompact(String workerId) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void markCompacted(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_state = 'r', cq_worker_id = null where cq_id = " + info.id;
                LOG.debug("Going to execute update <" + s + ">");
                int updCnt = stmt.executeUpdate(s);
                if (updCnt != 1) {
                    LOG.error("Unable to set cq_state=r for compaction record: " + info + ". updCnt=" + updCnt);
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to update compaction queue " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "markCompacted(" + info + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCompacted(info);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToClean() throws MetaException {
        ArrayList<CompactionInfo> arrayList;
        Connection dbConn = null;
        ArrayList<CompactionInfo> rc = new ArrayList<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "select cq_id, cq_database, cq_table, cq_partition, cq_type, cq_run_as, cq_highest_write_id from COMPACTION_QUEUE where cq_state = 'r'";
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            while (rs.next()) {
                CompactionInfo info = new CompactionInfo();
                info.id = rs.getLong(1);
                info.dbname = rs.getString(2);
                info.tableName = rs.getString(3);
                info.partName = rs.getString(4);
                switch (rs.getString(5).charAt(0)) {
                    case 'a': {
                        info.type = CompactionType.MAJOR;
                        break;
                    }
                    case 'i': {
                        info.type = CompactionType.MINOR;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction type " + rs.getString(5));
                    }
                }
                info.runAs = rs.getString(6);
                info.highestWriteId = rs.getLong(7);
                rc.add(info);
            }
            LOG.debug("Going to rollback");
            dbConn.rollback();
            arrayList = rc;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("Unable to select next element for cleaning, " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findReadyToClean");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException e2) {
                return this.findReadyToClean();
            }
        }
        CompactionTxnHandler.close(rs, stmt, dbConn);
        return arrayList;
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markCleaned(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = null;
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                dbConn = this.getDbConn(2);
                pStmt = dbConn.prepareStatement("select CQ_ID, CQ_DATABASE, CQ_TABLE, CQ_PARTITION, CQ_STATE, CQ_TYPE, CQ_TBLPROPERTIES, CQ_WORKER_ID, CQ_START, CQ_RUN_AS, CQ_HIGHEST_WRITE_ID, CQ_META_INFO, CQ_HADOOP_JOB_ID from COMPACTION_QUEUE WHERE CQ_ID = ?");
                pStmt.setLong(1, info.id);
                rs = pStmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalStateException("No record with CQ_ID=" + info.id + " found in COMPACTION_QUEUE");
                }
                info = CompactionInfo.loadFullFromCompactionQueue(rs);
                CompactionTxnHandler.close(rs);
                String s = "delete from COMPACTION_QUEUE where cq_id = ?";
                pStmt = dbConn.prepareStatement(s);
                pStmt.setLong(1, info.id);
                LOG.debug("Going to execute update <" + s + ">");
                int updCount = pStmt.executeUpdate();
                if (updCount != 1) {
                    LOG.error("Unable to delete compaction record: " + info + ".  Update count=" + updCount);
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                }
                pStmt = dbConn.prepareStatement("insert into COMPLETED_COMPACTIONS(CC_ID, CC_DATABASE, CC_TABLE, CC_PARTITION, CC_STATE, CC_TYPE, CC_TBLPROPERTIES, CC_WORKER_ID, CC_START, CC_END, CC_RUN_AS, CC_HIGHEST_WRITE_ID, CC_META_INFO, CC_HADOOP_JOB_ID) VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?)");
                info.state = (char)115;
                CompactionInfo.insertIntoCompletedCompactions(pStmt, info, this.getDbTime(dbConn));
                updCount = pStmt.executeUpdate();
                s = "delete from COMPLETED_TXN_COMPONENTS where ctc_database = ? and ctc_table = ?";
                if (info.partName != null) {
                    s = s + " and ctc_partition = ?";
                }
                if (info.highestWriteId != 0L) {
                    s = s + " and ctc_writeid <= ?";
                }
                pStmt = dbConn.prepareStatement(s);
                int paramCount = 1;
                pStmt.setString(paramCount++, info.dbname);
                pStmt.setString(paramCount++, info.tableName);
                if (info.partName != null) {
                    pStmt.setString(paramCount++, info.partName);
                }
                if (info.highestWriteId != 0L) {
                    pStmt.setLong(paramCount++, info.highestWriteId);
                }
                LOG.debug("Going to execute update <" + s + ">");
                if (pStmt.executeUpdate() < 1) {
                    LOG.error("Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
                }
                s = "select distinct txn_id from TXNS, TXN_COMPONENTS where txn_id = tc_txnid and txn_state = 'a' and tc_database = ? and tc_table = ?";
                if (info.highestWriteId != 0L) {
                    s = s + " and tc_writeid <= ?";
                }
                if (info.partName != null) {
                    s = s + " and tc_partition = ?";
                }
                pStmt = dbConn.prepareStatement(s);
                paramCount = 1;
                pStmt.setString(paramCount++, info.dbname);
                pStmt.setString(paramCount++, info.tableName);
                if (info.highestWriteId != 0L) {
                    pStmt.setLong(paramCount++, info.highestWriteId);
                }
                if (info.partName != null) {
                    pStmt.setString(paramCount++, info.partName);
                }
                LOG.debug("Going to execute update <" + s + ">");
                rs = pStmt.executeQuery();
                ArrayList<Long> txnids = new ArrayList<Long>();
                ArrayList<String> questions = new ArrayList<String>();
                while (rs.next()) {
                    long id = rs.getLong(1);
                    txnids.add(id);
                    questions.add("?");
                }
                if (txnids.size() > 0) {
                    ArrayList<String> queries = new ArrayList<String>();
                    StringBuilder prefix = new StringBuilder();
                    StringBuilder suffix = new StringBuilder();
                    prefix.append("delete from TXN_COMPONENTS where ");
                    suffix.append(" and tc_database = ?");
                    suffix.append(" and tc_table = ?");
                    if (info.partName != null) {
                        suffix.append(" and tc_partition = ?");
                    }
                    List<Integer> counts = TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, suffix, questions, "tc_txnid", true, false);
                    int totalCount = 0;
                    for (int i = 0; i < queries.size(); ++i) {
                        String query = (String)queries.get(i);
                        int insertCount = counts.get(i);
                        LOG.debug("Going to execute update <" + query + ">");
                        pStmt = dbConn.prepareStatement(query);
                        for (int j = 0; j < insertCount; ++j) {
                            pStmt.setLong(j + 1, (Long)txnids.get(totalCount + j));
                        }
                        totalCount += insertCount;
                        paramCount = insertCount + 1;
                        pStmt.setString(paramCount++, info.dbname);
                        pStmt.setString(paramCount++, info.tableName);
                        if (info.partName != null) {
                            pStmt.setString(paramCount++, info.partName);
                        }
                        int rc = pStmt.executeUpdate();
                        LOG.debug("Removed " + rc + " records from txn_components");
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from compaction queue " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "markCleaned(" + info + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, pStmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCleaned(info);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanTxnToWriteIdTable() throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                long minAbortedTxnId;
                long minOpenTxnId;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select ntxn_next from NEXT_TXN_ID";
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
                }
                long minUncommittedTxnId = rs.getLong(1);
                s = "select min(mhl_min_open_txnid) from MIN_HISTORY_LEVEL";
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next() && (minOpenTxnId = rs.getLong(1)) > 0L) {
                    minUncommittedTxnId = Math.min(minOpenTxnId, minUncommittedTxnId);
                }
                s = "select min(txn_id) from TXNS where txn_state = " + CompactionTxnHandler.quoteChar('a');
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                if (rs.next() && (minAbortedTxnId = rs.getLong(1)) > 0L) {
                    minUncommittedTxnId = Math.min(minAbortedTxnId, minUncommittedTxnId);
                }
                s = "delete from TXN_TO_WRITE_ID where t2w_txnid < " + minUncommittedTxnId;
                LOG.debug("Going to execute delete <" + s + ">");
                int rc = stmt.executeUpdate(s);
                LOG.info("Removed " + rc + " rows from TXN_TO_WRITE_ID with Txn Low-Water-Mark: " + minUncommittedTxnId);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from txns table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "cleanTxnToWriteIdTable");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.cleanTxnToWriteIdTable();
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanEmptyAbortedTxns() throws MetaException {
        try {
            ArrayList<Long> txnids;
            ResultSet rs;
            Statement stmt;
            Connection dbConn;
            block9: {
                dbConn = null;
                stmt = null;
                rs = null;
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "select txn_id from TXNS where txn_id not in (select tc_txnid from TXN_COMPONENTS) and txn_state = 'a'";
                LOG.debug("Going to execute query <" + s + ">");
                rs = stmt.executeQuery(s);
                txnids = new ArrayList<Long>();
                while (rs.next()) {
                    txnids.add(rs.getLong(1));
                }
                CompactionTxnHandler.close(rs);
                if (txnids.size() > 0) break block9;
                CompactionTxnHandler.close(rs, stmt, dbConn);
                return;
            }
            try {
                Collections.sort(txnids);
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder();
                StringBuilder suffix = new StringBuilder();
                prefix.append("delete from TXNS where ");
                suffix.append("");
                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "txn_id", false, false);
                for (String query : queries) {
                    LOG.debug("Going to execute update <" + query + ">");
                    int rc = stmt.executeUpdate(query);
                    LOG.info("Removed " + rc + "  empty Aborted transactions from TXNS");
                }
                LOG.info("Aborted transactions removed from TXNS: " + txnids);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from txns table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "cleanEmptyAbortedTxns");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.cleanEmptyAbortedTxns();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeFromLocalWorkers(String hostname) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_worker_id = null, cq_start = null, cq_state = 'i' where cq_state = 'w' and cq_worker_id like '" + hostname + "%'";
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to change dead worker's records back to initiated state " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "revokeFromLocalWorkers(hostname:" + hostname + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeFromLocalWorkers(hostname);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeTimedoutWorkers(long timeout) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                long latestValidStart = this.getDbTime(dbConn) - timeout;
                stmt = dbConn.createStatement();
                String s = "update COMPACTION_QUEUE set cq_worker_id = null, cq_start = null, cq_state = 'i' where cq_state = 'w' and cq_start < " + latestValidStart;
                LOG.debug("Going to execute update <" + s + ">");
                stmt.executeUpdate(s);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to change dead worker's records back to initiated state " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "revokeTimedoutWorkers(timeout:" + timeout + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeTimedoutWorkers(timeout);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<String> findColumnsWithStats(CompactionInfo ci) throws MetaException {
        ArrayList<String> arrayList;
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            String quote = this.getIdentifierQuoteString(dbConn);
            StringBuilder bldr = new StringBuilder();
            bldr.append("SELECT ").append(quote).append("COLUMN_NAME").append(quote).append(" FROM ").append(quote).append(ci.partName == null ? "TAB_COL_STATS" : "PART_COL_STATS").append(quote).append(" WHERE ").append(quote).append("DB_NAME").append(quote).append(" = ?").append(" AND ").append(quote).append("TABLE_NAME").append(quote).append(" = ?");
            if (ci.partName != null) {
                bldr.append(" AND ").append(quote).append("PARTITION_NAME").append(quote).append(" = ?");
            }
            String s = bldr.toString();
            pStmt = dbConn.prepareStatement(s);
            pStmt.setString(1, ci.dbname);
            pStmt.setString(2, ci.tableName);
            if (ci.partName != null) {
                pStmt.setString(3, ci.partName);
            }
            LOG.debug("Going to execute <" + s + ">");
            rs = pStmt.executeQuery();
            ArrayList<String> columns = new ArrayList<String>();
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            LOG.debug("Found columns to update stats: " + columns + " on " + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName));
            dbConn.commit();
            arrayList = columns;
        }
        catch (SQLException e) {
            try {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "findColumnsWithStats(" + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName) + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException ex) {
                return this.findColumnsWithStats(ci);
            }
        }
        CompactionTxnHandler.close(rs, pStmt, dbConn);
        return arrayList;
    }

    @Override
    @RetrySemantics.Idempotent
    public void setCompactionHighestWriteId(CompactionInfo ci, long highestWriteId) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                int updCount = stmt.executeUpdate("UPDATE COMPACTION_QUEUE SET CQ_HIGHEST_WRITE_ID = " + highestWriteId + " WHERE CQ_ID = " + ci.id);
                if (updCount != 1) {
                    throw new IllegalStateException("Could not find record in COMPACTION_QUEUE for " + ci);
                }
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "setCompactionHighestWriteId(" + ci + "," + highestWriteId + ")");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(null, stmt, dbConn);
        }
        catch (TxnHandler.RetryException ex) {
            this.setCompactionHighestWriteId(ci, highestWriteId);
        }
    }

    private void checkForDeletion(List<Long> deleteSet, CompactionInfo ci, RetentionCounters rc) {
        switch (ci.state) {
            case 'a': {
                if (--rc.attemptedRetention >= 0) break;
                deleteSet.add(ci.id);
                break;
            }
            case 'f': {
                if (--rc.failedRetention >= 0) break;
                deleteSet.add(ci.id);
                break;
            }
            case 's': {
                if (--rc.succeededRetention >= 0) break;
                deleteSet.add(ci.id);
                break;
            }
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void purgeCompactionHistory() throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        ArrayList<Long> deleteSet = new ArrayList<Long>();
        RetentionCounters rc = null;
        try {
            block12: {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery("select cc_id, cc_database, cc_table, cc_partition, cc_state from COMPLETED_COMPACTIONS order by cc_database, cc_table, cc_partition, cc_id desc");
                String lastCompactedEntity = null;
                while (rs.next()) {
                    CompactionInfo ci = new CompactionInfo(rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5).charAt(0));
                    if (!ci.getFullPartitionName().equals(lastCompactedEntity)) {
                        lastCompactedEntity = ci.getFullPartitionName();
                        rc = new RetentionCounters(MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_ATTEMPTED), this.getFailedCompactionRetention(), MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED));
                    }
                    this.checkForDeletion(deleteSet, ci, rc);
                }
                CompactionTxnHandler.close(rs);
                if (deleteSet.size() > 0) break block12;
                CompactionTxnHandler.close(rs, stmt, dbConn);
                CompactionTxnHandler.closeStmt(pStmt);
                return;
            }
            try {
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder();
                StringBuilder suffix = new StringBuilder();
                prefix.append("delete from COMPLETED_COMPACTIONS where ");
                suffix.append("");
                ArrayList<String> questions = new ArrayList<String>(deleteSet.size());
                for (int i = 0; i < deleteSet.size(); ++i) {
                    questions.add("?");
                }
                List<Integer> counts = TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, suffix, questions, "cc_id", false, false);
                int totalCount = 0;
                for (int i = 0; i < queries.size(); ++i) {
                    String query = (String)queries.get(i);
                    long insertCount = counts.get(i).intValue();
                    LOG.debug("Going to execute update <" + query + ">");
                    pStmt = dbConn.prepareStatement(query);
                    int j = 0;
                    while ((long)j < insertCount) {
                        pStmt.setLong(j + 1, (Long)deleteSet.get(totalCount + j));
                        ++j;
                    }
                    totalCount = (int)((long)totalCount + insertCount);
                    int count = pStmt.executeUpdate();
                    LOG.debug("Removed " + count + " records from COMPLETED_COMPACTIONS");
                }
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(dbConn, e, "purgeCompactionHistory()");
                    throw new MetaException("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    CompactionTxnHandler.closeStmt(pStmt);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
            CompactionTxnHandler.closeStmt(pStmt);
        }
        catch (TxnHandler.RetryException ex) {
            this.purgeCompactionHistory();
        }
    }

    private int getFailedCompactionRetention() {
        int failedThreshold = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        int failedRetention = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED);
        if (failedRetention < failedThreshold) {
            LOG.warn("Invalid configuration " + MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname() + "=" + failedRetention + " < " + (Object)((Object)MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED) + "=" + failedRetention + ".  Will use " + MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname() + "=" + failedRetention);
            failedRetention = failedThreshold;
        }
        return failedRetention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public boolean checkFailedCompactions(CompactionInfo ci) throws MetaException {
        boolean bl;
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            pStmt = dbConn.prepareStatement("select CC_STATE from COMPLETED_COMPACTIONS where CC_DATABASE = ? and CC_TABLE = ? " + (ci.partName != null ? "and CC_PARTITION = ?" : "") + " and CC_STATE != " + CompactionTxnHandler.quoteChar('a') + " order by CC_ID desc");
            pStmt.setString(1, ci.dbname);
            pStmt.setString(2, ci.tableName);
            if (ci.partName != null) {
                pStmt.setString(3, ci.partName);
            }
            rs = pStmt.executeQuery();
            int numFailed = 0;
            int numTotal = 0;
            int failedThreshold = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
            while (rs.next() && ++numTotal <= failedThreshold) {
                if (rs.getString(1).charAt(0) == 'f') {
                    ++numFailed;
                    continue;
                }
                --numFailed;
            }
            bl = numFailed == failedThreshold;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                LOG.error("Unable to check for failed compactions " + e.getMessage());
                LOG.debug("Going to rollback");
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(dbConn, e, "checkFailedCompactions(" + ci + ")");
                LOG.error("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)e));
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
                catch (TxnHandler.RetryException e2) {
                    return this.checkFailedCompactions(ci);
                }
            }
            CompactionTxnHandler.close(rs, pStmt, dbConn);
            return bl2;
        }
        CompactionTxnHandler.close(rs, pStmt, dbConn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.CannotRetry
    public void markFailed(CompactionInfo ci) throws MetaException {
        block14: {
            try {
                Connection dbConn = null;
                Statement stmt = null;
                PreparedStatement pStmt = null;
                ResultSet rs = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    pStmt = dbConn.prepareStatement("select CQ_ID, CQ_DATABASE, CQ_TABLE, CQ_PARTITION, CQ_STATE, CQ_TYPE, CQ_TBLPROPERTIES, CQ_WORKER_ID, CQ_START, CQ_RUN_AS, CQ_HIGHEST_WRITE_ID, CQ_META_INFO, CQ_HADOOP_JOB_ID from COMPACTION_QUEUE WHERE CQ_ID = ?");
                    pStmt.setLong(1, ci.id);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        ci = CompactionInfo.loadFullFromCompactionQueue(rs);
                        String s = "delete from COMPACTION_QUEUE where cq_id = ?";
                        pStmt = dbConn.prepareStatement(s);
                        pStmt.setLong(1, ci.id);
                        LOG.debug("Going to execute update <" + s + ">");
                        int n = pStmt.executeUpdate();
                    } else if (ci.id > 0L) {
                        throw new IllegalStateException("No record with CQ_ID=" + ci.id + " found in COMPACTION_QUEUE");
                    }
                    if (ci.id == 0L) {
                        ci.id = this.generateCompactionQueueId(stmt);
                        ci.state = (char)97;
                        if (ci.type == null) {
                            ci.type = CompactionType.MINOR;
                        }
                        ci.start = this.getDbTime(dbConn);
                    } else {
                        ci.state = (char)102;
                    }
                    CompactionTxnHandler.close(rs, stmt, null);
                    CompactionTxnHandler.closeStmt(pStmt);
                    pStmt = dbConn.prepareStatement("insert into COMPLETED_COMPACTIONS(CC_ID, CC_DATABASE, CC_TABLE, CC_PARTITION, CC_STATE, CC_TYPE, CC_TBLPROPERTIES, CC_WORKER_ID, CC_START, CC_END, CC_RUN_AS, CC_HIGHEST_WRITE_ID, CC_META_INFO, CC_HADOOP_JOB_ID) VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?)");
                    CompactionInfo.insertIntoCompletedCompactions(pStmt, ci, this.getDbTime(dbConn));
                    int updCount = pStmt.executeUpdate();
                    LOG.debug("Going to commit");
                    CompactionTxnHandler.closeStmt(pStmt);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.warn("markFailed(" + ci.id + "):" + e.getMessage());
                        LOG.debug("Going to rollback");
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        try {
                            this.checkRetryable(dbConn, e, "markFailed(" + ci + ")");
                        }
                        catch (MetaException ex) {
                            LOG.error("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)((Object)ex)));
                        }
                        LOG.error("markFailed(" + ci + ") failed: " + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(rs, stmt, null);
                        CompactionTxnHandler.close(null, pStmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(rs, stmt, null);
                    CompactionTxnHandler.close(null, pStmt, dbConn);
                    break block14;
                }
                CompactionTxnHandler.close(rs, stmt, null);
                CompactionTxnHandler.close(null, pStmt, dbConn);
            }
            catch (TxnHandler.RetryException e) {
                this.markFailed(ci);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.Idempotent
    public void setHadoopJobId(String hadoopJobId, long id) {
        block8: {
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    String s = "update COMPACTION_QUEUE set CQ_HADOOP_JOB_ID = " + CompactionTxnHandler.quoteString(hadoopJobId) + " WHERE CQ_ID = " + id;
                    LOG.debug("Going to execute <" + s + ">");
                    int updateCount = stmt.executeUpdate(s);
                    LOG.debug("Going to commit");
                    CompactionTxnHandler.closeStmt(stmt);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.warn("setHadoopJobId(" + hadoopJobId + "," + id + "):" + e.getMessage());
                        LOG.debug("Going to rollback");
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        try {
                            this.checkRetryable(dbConn, e, "setHadoopJobId(" + hadoopJobId + "," + id + ")");
                        }
                        catch (MetaException ex) {
                            LOG.error("Unable to connect to transaction database " + StringUtils.stringifyException((Throwable)((Object)ex)));
                        }
                        LOG.error("setHadoopJobId(" + hadoopJobId + "," + id + ") failed: " + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(null, stmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    break block8;
                }
                CompactionTxnHandler.close(null, stmt, dbConn);
            }
            catch (TxnHandler.RetryException e) {
                this.setHadoopJobId(hadoopJobId, id);
            }
        }
    }

    private static class RetentionCounters {
        int attemptedRetention = 0;
        int failedRetention = 0;
        int succeededRetention = 0;

        RetentionCounters(int attemptedRetention, int failedRetention, int succeededRetention) {
            this.attemptedRetention = attemptedRetention;
            this.failedRetention = failedRetention;
            this.succeededRetention = succeededRetention;
        }
    }
}

