/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;

public class LlapArrowRecordWriter<K extends Writable, V extends Writable>
implements RecordWriter<K, V> {
    public static final Logger LOG = LoggerFactory.getLogger(LlapArrowRecordWriter.class);
    ArrowStreamWriter arrowStreamWriter;
    WritableByteChannel out;

    public LlapArrowRecordWriter(WritableByteChannel out) {
        this.out = out;
    }

    public void close(Reporter reporter) throws IOException {
        this.arrowStreamWriter.close();
    }

    public void write(K key, V value) throws IOException {
        ArrowWrapperWritable arrowWrapperWritable = (ArrowWrapperWritable)value;
        if (this.arrowStreamWriter == null) {
            VectorSchemaRoot vectorSchemaRoot = arrowWrapperWritable.getVectorSchemaRoot();
            this.arrowStreamWriter = new ArrowStreamWriter(vectorSchemaRoot, null, this.out);
        }
        this.arrowStreamWriter.writeBatch();
    }
}

