/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl.writer;

import io.trino.hive.orc.TypeDescription;
import io.trino.hive.orc.impl.writer.StringBaseTreeWriter;
import io.trino.hive.orc.impl.writer.WriterContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class StringTreeWriter
extends StringBaseTreeWriter {
    StringTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block10: {
            BytesColumnVector vec;
            block9: {
                super.writeBatch(vector, offset, length);
                vec = (BytesColumnVector)vector;
                if (!vector.isRepeating) break block9;
                if (!vector.noNulls && vector.isNull[0]) break block10;
                if (this.useDictionaryEncoding) {
                    int id = this.dictionary.add(vec.vector[0], vec.start[0], vec.length[0]);
                    for (int i = 0; i < length; ++i) {
                        this.rows.add(id);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.directStreamOutput.write(vec.vector[0], vec.start[0], vec.length[0]);
                        this.lengthOutput.write(vec.length[0]);
                    }
                }
                this.indexStatistics.updateString(vec.vector[0], vec.start[0], vec.length[0], length);
                if (!this.createBloomFilter) break block10;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(new String(vec.vector[0], vec.start[0], vec.length[0], StandardCharsets.UTF_8));
                }
                this.bloomFilterUtf8.addBytes(vec.vector[0], vec.start[0], vec.length[0]);
                break block10;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                if (this.useDictionaryEncoding) {
                    this.rows.add(this.dictionary.add(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]));
                } else {
                    this.directStreamOutput.write(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
                    this.lengthOutput.write(vec.length[offset + i]);
                }
                this.indexStatistics.updateString(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i], 1);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(new String(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i], StandardCharsets.UTF_8));
                }
                this.bloomFilterUtf8.addBytes(vec.vector[offset + i], vec.start[offset + i], vec.length[offset + i]);
            }
        }
    }
}

