/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.orc.impl.writer;

import io.trino.hive.orc.OrcProto;
import io.trino.hive.orc.TypeDescription;
import io.trino.hive.orc.impl.OutStream;
import io.trino.hive.orc.impl.PositionRecorder;
import io.trino.hive.orc.impl.RunLengthIntegerWriterV2;
import io.trino.hive.orc.impl.writer.TreeWriterBase;
import io.trino.hive.orc.impl.writer.WriterContext;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class Decimal64TreeWriter
extends TreeWriterBase {
    private final RunLengthIntegerWriterV2 valueWriter;
    private final int scale;

    public Decimal64TreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        OutStream stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
        this.valueWriter = new RunLengthIntegerWriterV2(stream, true, true);
        this.scale = schema.getScale();
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    private void writeBatch(DecimalColumnVector vector, int offset, int length) throws IOException {
        block4: {
            block3: {
                if (!vector.isRepeating) break block3;
                if (!vector.noNulls && vector.isNull[0]) break block4;
                HiveDecimalWritable value = vector.vector[0];
                long lg = value.serialize64(this.scale);
                this.indexStatistics.updateDecimal64(lg, this.scale);
                if (this.createBloomFilter) {
                    this.bloomFilterUtf8.addLong(lg);
                }
                for (int i = 0; i < length; ++i) {
                    this.valueWriter.write(lg);
                }
                break block4;
            }
            for (int i = 0; i < length; ++i) {
                if (!vector.noNulls && vector.isNull[i + offset]) continue;
                HiveDecimalWritable value = vector.vector[i + offset];
                long lg = value.serialize64(this.scale);
                this.valueWriter.write(lg);
                this.indexStatistics.updateDecimal64(lg, this.scale);
                if (!this.createBloomFilter) continue;
                this.bloomFilterUtf8.addLong(lg);
            }
        }
    }

    private void writeBatch(Decimal64ColumnVector vector, int offset, int length) throws IOException {
        block5: {
            block4: {
                assert (this.scale == vector.scale);
                if (!vector.isRepeating) break block4;
                if (!vector.noNulls && vector.isNull[0]) break block5;
                long lg = vector.vector[0];
                this.indexStatistics.updateDecimal64(lg, this.scale);
                if (this.createBloomFilter) {
                    this.bloomFilterUtf8.addLong(lg);
                }
                for (int i = 0; i < length; ++i) {
                    this.valueWriter.write(lg);
                }
                break block5;
            }
            for (int i = 0; i < length; ++i) {
                if (!vector.noNulls && vector.isNull[i + offset]) continue;
                long lg = vector.vector[i + offset];
                this.valueWriter.write(lg);
                this.indexStatistics.updateDecimal64(lg, this.scale);
                if (!this.createBloomFilter) continue;
                this.bloomFilterUtf8.addLong(lg);
            }
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        super.writeBatch(vector, offset, length);
        if (vector instanceof Decimal64ColumnVector) {
            this.writeBatch((Decimal64ColumnVector)vector, offset, length);
        } else {
            this.writeBatch((DecimalColumnVector)vector, offset, length);
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        super.writeStripe(builder, stats, requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.valueWriter.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.valueWriter.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        return this.fileStatistics.getNumberOfValues() * (long)JavaDataModel.get().primitive2();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.valueWriter.flush();
    }
}

