/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.presto;

import io.trino.benchto.driver.Measurable;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import io.trino.benchto.driver.presto.PrestoClient;
import io.trino.benchto.driver.service.Measurement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.presto", value={"metrics.collection.enabled"})
public class PrestoMetricsLoader
implements PostExecutionMeasurementProvider {
    @Autowired
    private PrestoClient prestoClient;

    @Override
    public CompletableFuture<List<Measurement>> loadMeasurements(Measurable measurable) {
        QueryExecutionResult executionResult;
        if (measurable instanceof QueryExecutionResult && (executionResult = (QueryExecutionResult)measurable).getPrestoQueryId().isPresent() && !executionResult.getBenchmark().isThroughputTest()) {
            return CompletableFuture.completedFuture(this.prestoClient.loadMetrics(executionResult.getPrestoQueryId().get()));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }
}

