/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.macro.shell;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.BenchmarkExecutionException;
import io.trino.benchto.driver.macro.MacroExecutionDriver;
import io.trino.benchto.driver.macro.shell.ShellMacrosProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShellMacroExecutionDriver
implements MacroExecutionDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellMacroExecutionDriver.class);
    private static final String SHELL = "bash";
    @Autowired
    private ShellMacrosProperties macros;

    @Override
    public boolean canExecuteBenchmarkMacro(String macroName) {
        return this.macros.getMacros().containsKey(macroName);
    }

    @Override
    public void runBenchmarkMacro(String macroName, Optional<Benchmark> benchmark, Optional<Connection> connection) {
        this.runBenchmarkMacro(macroName, (Map<String, String>)ImmutableMap.of());
    }

    public void runBenchmarkMacro(String macroName, Map<String, String> environment) {
        try {
            String macroCommand = this.getMacroCommand(macroName);
            ProcessBuilder processBuilder = new ProcessBuilder(SHELL, "-c", macroCommand);
            processBuilder.environment().putAll(environment);
            Process macroProcess = processBuilder.start();
            LOGGER.info("Executing macro: '{}'", (Object)macroCommand);
            macroProcess.waitFor();
            boolean completedSuccessfully = macroProcess.exitValue() == 0;
            this.printOutput(macroProcess, !completedSuccessfully);
            Preconditions.checkState((boolean)completedSuccessfully, (String)"Macro %s exited with code %s", (Object)macroName, (int)macroProcess.exitValue());
        }
        catch (IOException | InterruptedException e) {
            throw new BenchmarkExecutionException("Could not execute macro " + macroName, e);
        }
    }

    private String getMacroCommand(String macroName) {
        Preconditions.checkArgument((boolean)this.macros.getMacros().containsKey(macroName), (String)"Macro %s is not defined", (Object)macroName);
        return Objects.requireNonNull(this.macros.getMacros().get(macroName).getCommand(), "Macro " + macroName + " has no command defined");
    }

    private void printOutput(Process process, boolean stdoutAsError) throws IOException {
        this.logStream(process.getInputStream(), line -> {
            line = "stdout: " + (String)line;
            if (stdoutAsError) {
                LOGGER.error((String)line);
            } else {
                LOGGER.debug((String)line);
            }
        });
        this.logStream(process.getErrorStream(), line -> LOGGER.error("stderr: " + line));
    }

    private void logStream(InputStream inputStream, Consumer<String> logger) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = input.readLine()) != null) {
                logger.accept(line);
            }
        }
    }
}

