/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.macro.query;

import com.google.common.base.Preconditions;
import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.BenchmarkExecutionException;
import io.trino.benchto.driver.Query;
import io.trino.benchto.driver.loader.QueryLoader;
import io.trino.benchto.driver.loader.SqlStatementGenerator;
import io.trino.benchto.driver.macro.MacroExecutionDriver;
import io.trino.benchto.driver.utils.QueryUtils;
import io.trino.jdbc.TrinoConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class QueryMacroExecutionDriver
implements MacroExecutionDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryMacroExecutionDriver.class);
    private static final String SET_SESSION = "set session";
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("([^=]+)='??([^']+)'??");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private QueryLoader queryLoader;
    @Autowired
    private SqlStatementGenerator sqlStatementGenerator;

    @Override
    public boolean canExecuteBenchmarkMacro(String macroName) {
        return macroName.endsWith(".sql");
    }

    @Override
    public void runBenchmarkMacro(String macroName, Optional<Benchmark> benchmarkOptional, Optional<Connection> connectionOptional) {
        block9: {
            Preconditions.checkArgument((boolean)benchmarkOptional.isPresent(), (Object)"Benchmark is required to run query based macro");
            Benchmark benchmark = benchmarkOptional.get();
            Query macroQuery = this.queryLoader.loadFromFile(macroName);
            List<String> sqlStatements = this.sqlStatementGenerator.generateQuerySqlStatement(macroQuery, benchmark.getNonReservedKeywordVariables());
            try {
                if (connectionOptional.isPresent() && !macroQuery.getProperty("datasource").isPresent()) {
                    this.runSqlStatements(connectionOptional.get(), sqlStatements);
                    break block9;
                }
                String dataSourceName = macroQuery.getProperty("datasource", benchmark.getDataSource());
                try (Connection connection = this.getConnectionFor(dataSourceName);){
                    this.runSqlStatements(connection, sqlStatements);
                }
            }
            catch (SQLException e) {
                throw new BenchmarkExecutionException("Could not execute macro SQL queries for benchmark: " + benchmark, e);
            }
        }
    }

    private void runSqlStatements(Connection connection, List<String> sqlStatements) throws SQLException {
        for (String sqlStatement : sqlStatements) {
            sqlStatement = sqlStatement.trim();
            LOGGER.info("Executing macro query: {}", (Object)sqlStatement);
            if (sqlStatement.toLowerCase().startsWith(SET_SESSION) && connection.isWrapperFor(TrinoConnection.class)) {
                this.setSessionForTrino(connection, sqlStatement);
                continue;
            }
            Statement statement = connection.createStatement();
            try {
                if (!statement.execute(sqlStatement)) continue;
                ResultSet resultSet = statement.getResultSet();
                try {
                    QueryUtils.fetchRows(sqlStatement, resultSet);
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }

    private void setSessionForTrino(Connection connection, String sqlStatement) {
        TrinoConnection trinoConnection;
        try {
            trinoConnection = connection.unwrap(TrinoConnection.class);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage());
            throw new UnsupportedOperationException(String.format("SET SESSION for non PrestoConnection [%s] is not supported", connection.getClass()));
        }
        String[] keyValue = QueryMacroExecutionDriver.extractKeyValue(sqlStatement);
        trinoConnection.setSessionProperty(keyValue[0].trim(), keyValue[1].trim());
    }

    public static String[] extractKeyValue(String sqlStatement) {
        String keyValueSql = sqlStatement.substring(SET_SESSION.length()).trim();
        Matcher matcher = KEY_VALUE_PATTERN.matcher(keyValueSql);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Unexpected SET SESSION format [%s]", (Object)sqlStatement);
        String[] keyValue = new String[]{matcher.group(1).trim(), matcher.group(2).trim()};
        return keyValue;
    }

    private Connection getConnectionFor(String dataSourceName) throws SQLException {
        return ((DataSource)this.applicationContext.getBean(dataSourceName, DataSource.class)).getConnection();
    }
}

