/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.loader;

import com.google.common.collect.ImmutableMap;
import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.BenchmarkProperties;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BenchmarkByActiveVariablesFilter
implements Predicate<Benchmark> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarkByActiveVariablesFilter.class);
    private final Map<String, Pattern> variablePatterns;

    public BenchmarkByActiveVariablesFilter(BenchmarkProperties properties) {
        Optional<Map<String, String>> activeVariables = Objects.requireNonNull(properties, "properties is null").getActiveVariables();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (activeVariables.isPresent()) {
            for (String variableKey : activeVariables.get().keySet()) {
                builder.put((Object)variableKey, (Object)Pattern.compile(activeVariables.get().get(variableKey)));
            }
        }
        this.variablePatterns = builder.build();
    }

    @Override
    public boolean test(Benchmark benchmark) {
        Map<String, String> benchmarkVariables = benchmark.getVariables();
        for (String variableKey : this.variablePatterns.keySet()) {
            if (benchmarkVariables.containsKey(variableKey)) {
                String benchmarkVariableValue;
                Pattern valuePattern = this.variablePatterns.get(variableKey);
                if (valuePattern.matcher(benchmarkVariableValue = benchmarkVariables.get(variableKey)).matches()) continue;
                LOGGER.debug("Benchmark '{}' is EXCLUDED because mismatches on variable '{}', have '{}' does not match to '{}'", new Object[]{benchmark.getName(), variableKey, valuePattern, benchmarkVariableValue});
                return false;
            }
            return false;
        }
        return true;
    }
}

