/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.loader;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import io.trino.benchto.driver.Query;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class AnnotatedQueryParser {
    private static final String COMMENT_LINE_PREFIX = "--";
    private static final String PROPERTIES_LINE_PREFIX = "--!";
    private static final Splitter.MapSplitter PROPERTIES_SPLITTER = Splitter.on((char)';').omitEmptyStrings().trimResults().withKeyValueSeparator(Splitter.on((String)":").trimResults());

    public Query parseFile(String queryName, Path inputFile) throws IOException {
        try (Stream<String> lines = Files.lines(inputFile, StandardCharsets.UTF_8);){
            Query query = this.parseLines(queryName, lines.collect(Collectors.toList()));
            return query;
        }
    }

    public Query parseLines(String queryName, List<String> lines) {
        lines = lines.stream().map(String::trim).collect(Collectors.toList());
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String line : lines) {
            if (!this.isPropertiesLine(line)) continue;
            Map<String, String> lineProperties = this.parseLineProperties(line);
            Map difference = Maps.difference(properties, lineProperties).entriesDiffering();
            Preconditions.checkState((boolean)difference.isEmpty(), (String)"Different properties: ", (Object)difference);
            properties.putAll(lineProperties);
        }
        String contentFiltered = lines.stream().filter(this::isNotCommentLine).collect(Collectors.joining("\n"));
        return new Query(queryName, contentFiltered, properties);
    }

    private Map<String, String> parseLineProperties(String line) {
        Preconditions.checkArgument((boolean)this.isPropertiesLine(line));
        return PROPERTIES_SPLITTER.split((CharSequence)line.substring(line.indexOf("!") + 1));
    }

    private boolean isPropertiesLine(String line) {
        return line.startsWith(PROPERTIES_LINE_PREFIX);
    }

    private boolean isNotCommentLine(String s) {
        return !s.startsWith(COMMENT_LINE_PREFIX);
    }
}

