/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.listeners;

import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import io.trino.benchto.driver.execution.QueryExecution;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggingBenchmarkExecutionListener
implements BenchmarkExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingBenchmarkExecutionListener.class);

    public int getOrder() {
        return -100;
    }

    @Override
    public Future<?> benchmarkStarted(Benchmark benchmark) {
        LOG.info("Executing benchmark: {}", (Object)benchmark.getName());
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult result) {
        LOG.info("Finished benchmark: {}", (Object)result.getBenchmark().getName());
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> executionStarted(QueryExecution execution) {
        LOG.info("Query started: {} ({}/{})", new Object[]{execution.getQueryName(), execution.getSequenceId(), execution.getBenchmark().getRuns()});
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> executionFinished(QueryExecutionResult result) {
        if (result.isSuccessful()) {
            LOG.info("Query finished: {} ({}/{}), rows count: {}, duration: {}", new Object[]{result.getQueryName(), result.getQueryExecution().getSequenceId(), result.getBenchmark().getRuns(), result.getRowsCount(), result.getQueryDuration()});
        } else {
            LOG.error("Query failed: {} ({}/{}), execution error: {}", new Object[]{result.getQueryName(), result.getQueryExecution().getSequenceId(), result.getBenchmark().getRuns(), result.getFailureCause().getMessage()});
        }
        return CompletableFuture.completedFuture("");
    }

    @Override
    public Future<?> concurrencyTestExecutionFinished(List<QueryExecutionResult> executions) {
        LOG.info("Concurrency test queries finished, queries successful {}, queries failed {}", (Object)executions.stream().filter(QueryExecutionResult::isSuccessful).count(), (Object)executions.stream().filter(execution -> !execution.isSuccessful()).count());
        return CompletableFuture.completedFuture("");
    }
}

