/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.listeners;

import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import io.trino.benchto.driver.execution.ExecutionSynchronizer;
import io.trino.benchto.driver.execution.QueryExecution;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.graphite.GraphiteClient;
import io.trino.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="benchmark.feature.graphite", value={"event.reporting.enabled"})
public class GraphiteEventExecutionListener
implements BenchmarkExecutionListener {
    @Autowired
    private AsyncTaskExecutor taskExecutor;
    @Autowired
    private ExecutionSynchronizer executionSynchronizer;
    @Autowired
    private GraphiteClient graphiteClient;

    public int getOrder() {
        return 0;
    }

    @Override
    public Future<?> benchmarkStarted(Benchmark benchmark) {
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s started", benchmark.getUniqueName())).tags("benchmark", "started", benchmark.getEnvironment()).build();
        return this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult benchmarkExecutionResult) {
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s ended", benchmarkExecutionResult.getBenchmark().getUniqueName())).tags("benchmark", "ended", benchmarkExecutionResult.getEnvironment()).data(String.format("successful %b", benchmarkExecutionResult.isSuccessful())).when(benchmarkExecutionResult.getUtcEnd()).build();
        Future future = this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
        this.executionSynchronizer.awaitAfterBenchmarkExecutionAndBeforeResultReport(benchmarkExecutionResult.getBenchmark());
        return future;
    }

    @Override
    public Future<?> executionStarted(QueryExecution execution) {
        if (execution.getBenchmark().isConcurrent()) {
            return CompletableFuture.completedFuture("");
        }
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s, query %s (%d) started", execution.getBenchmark().getUniqueName(), execution.getQueryName(), execution.getSequenceId())).tags("execution", "started", execution.getBenchmark().getEnvironment()).build();
        return this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
    }

    @Override
    public Future<?> executionFinished(QueryExecutionResult executionResult) {
        if (executionResult.getBenchmark().isConcurrent()) {
            return CompletableFuture.completedFuture("");
        }
        QueryExecution queryExecution = executionResult.getQueryExecution();
        GraphiteClient.GraphiteEventRequest request = new GraphiteClient.GraphiteEventRequest.GraphiteEventRequestBuilder().what(String.format("Benchmark %s, query %s (%d) ended", queryExecution.getBenchmark().getUniqueName(), executionResult.getQueryName(), queryExecution.getSequenceId())).tags("execution", "ended", executionResult.getEnvironment()).data(String.format("duration: %d ms", executionResult.getQueryDuration().toMillis())).when(executionResult.getUtcEnd()).build();
        Future future = this.taskExecutor.submit(() -> this.graphiteClient.storeEvent(request));
        this.executionSynchronizer.awaitAfterQueryExecutionAndBeforeResultReport(executionResult);
        return future;
    }

    @Override
    public Future<?> concurrencyTestExecutionFinished(List<QueryExecutionResult> executions) {
        return CompletableFuture.completedFuture("");
    }
}

