/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver.listeners;

import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import io.trino.benchto.driver.Benchmark;
import io.trino.benchto.driver.Measurable;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import io.trino.benchto.driver.execution.QueryExecution;
import io.trino.benchto.driver.execution.QueryExecutionResult;
import io.trino.benchto.driver.listeners.benchmark.BenchmarkExecutionListener;
import io.trino.benchto.driver.listeners.measurements.PostExecutionMeasurementProvider;
import io.trino.benchto.driver.listeners.queryinfo.QueryInfoProvider;
import io.trino.benchto.driver.loader.BenchmarkDescriptor;
import io.trino.benchto.driver.service.BenchmarkServiceClient;
import io.trino.benchto.driver.service.Measurement;
import io.trino.benchto.driver.utils.ExceptionUtils;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class BenchmarkServiceExecutionListener
implements BenchmarkExecutionListener {
    private static final Duration MAX_CLOCK_DRIFT = Duration.of(1L, ChronoUnit.SECONDS);
    @Autowired
    private AsyncTaskExecutor taskExecutor;
    @Value(value="${benchmark-service.url}")
    private String serviceUrl;
    @Autowired
    private BenchmarkServiceClient benchmarkServiceClient;
    @Autowired
    private List<PostExecutionMeasurementProvider> measurementProviders;
    @Autowired(required=false)
    private QueryInfoProvider queryInfoProvider;

    public int getOrder() {
        return 0;
    }

    @Override
    public Future<?> benchmarkStarted(Benchmark benchmark) {
        this.checkClocksSync();
        return this.taskExecutor.submit(() -> {
            BenchmarkServiceClient.BenchmarkStartRequest.BenchmarkStartRequestBuilder requestBuilder = new BenchmarkServiceClient.BenchmarkStartRequest.BenchmarkStartRequestBuilder(benchmark.getName()).environmentName(benchmark.getEnvironment());
            for (Map.Entry<String, String> variableEntry : benchmark.getVariables().entrySet()) {
                if (BenchmarkDescriptor.RESERVED_KEYWORDS.contains(variableEntry.getKey())) {
                    requestBuilder.addAttribute(variableEntry.getKey(), variableEntry.getValue());
                    continue;
                }
                requestBuilder.addVariable(variableEntry.getKey(), variableEntry.getValue());
            }
            BenchmarkServiceClient.BenchmarkStartRequest request = (BenchmarkServiceClient.BenchmarkStartRequest)requestBuilder.build();
            this.benchmarkServiceClient.startBenchmark(benchmark.getUniqueName(), benchmark.getSequenceId(), request);
        });
    }

    private void checkClocksSync() {
        long approximationPrecision;
        long timeBefore = System.currentTimeMillis();
        long serviceTime = this.benchmarkServiceClient.getServiceCurrentTime().toEpochMilli();
        long timeAfter = System.currentTimeMillis();
        long driftApproximation = Math.abs(LongMath.mean((long)timeBefore, (long)timeAfter) - serviceTime);
        Duration driftLowerBound = Duration.of(driftApproximation - (approximationPrecision = timeAfter - LongMath.mean((long)timeBefore, (long)timeAfter)), ChronoUnit.MILLIS);
        if (driftLowerBound.compareTo(MAX_CLOCK_DRIFT) > 0) {
            throw new RuntimeException(String.format("Detected driver and service clocks drift of at least %s, assumed sane maximum is %s", driftLowerBound, MAX_CLOCK_DRIFT));
        }
    }

    @Override
    public Future<?> benchmarkFinished(BenchmarkExecutionResult benchmarkExecutionResult) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getMeasurements(benchmarkExecutionResult), arg_0 -> ((AsyncTaskExecutor)this.taskExecutor).execute(arg_0)).thenCompose(future -> future)).thenApply(measurements -> {
            BenchmarkServiceClient.FinishRequest.FinishRequestBuilder builder = new BenchmarkServiceClient.FinishRequest.FinishRequestBuilder().withStatus(benchmarkExecutionResult.isSuccessful() ? BenchmarkServiceClient.FinishRequest.Status.ENDED : BenchmarkServiceClient.FinishRequest.Status.FAILED).addMeasurements((Collection<Measurement>)measurements);
            if (benchmarkExecutionResult.getUtcEnd() != null) {
                builder.withEndTime(benchmarkExecutionResult.getUtcEnd().toInstant());
            }
            if (!benchmarkExecutionResult.getBenchmark().isThroughputTest()) {
                benchmarkExecutionResult.getExecutions().stream().findFirst().ifPresent(e -> builder.addAttribute("statement", e.getQueryExecution().getStatement()));
            }
            return (BenchmarkServiceClient.FinishRequest)builder.build();
        })).thenAccept(request -> this.benchmarkServiceClient.finishBenchmark(benchmarkExecutionResult.getBenchmark().getUniqueName(), benchmarkExecutionResult.getBenchmark().getSequenceId(), (BenchmarkServiceClient.FinishRequest)request));
    }

    @Override
    public Future<?> executionStarted(QueryExecution execution) {
        return this.taskExecutor.submit(() -> {
            BenchmarkServiceClient.ExecutionStartRequest request = (BenchmarkServiceClient.ExecutionStartRequest)new BenchmarkServiceClient.ExecutionStartRequest.ExecutionStartRequestBuilder().build();
            this.benchmarkServiceClient.startExecution(execution.getBenchmark().getUniqueName(), execution.getBenchmark().getSequenceId(), this.executionSequenceId(execution), request);
        });
    }

    @Override
    public Future<?> executionFinished(QueryExecutionResult executionResult) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getMeasurementsWithQueryInfo(executionResult), arg_0 -> ((AsyncTaskExecutor)this.taskExecutor).execute(arg_0)).thenCompose(future -> future)).thenApply(measurements -> this.buildExecutionFinishedRequest(executionResult, (MeasurementsWithQueryInfo)measurements))).thenAccept(request -> this.benchmarkServiceClient.finishExecution(executionResult.getBenchmark().getUniqueName(), executionResult.getBenchmark().getSequenceId(), this.executionSequenceId(executionResult.getQueryExecution()), (BenchmarkServiceClient.FinishRequest)request));
    }

    @Override
    public Future<?> concurrencyTestExecutionFinished(List<QueryExecutionResult> executions) {
        if (executions.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.taskExecutor.submit(() -> {
            BenchmarkServiceClient.FinishRequest finishRequest = (BenchmarkServiceClient.FinishRequest)new BenchmarkServiceClient.FinishRequest.FinishRequestBuilder().withStatus(BenchmarkServiceClient.FinishRequest.Status.ENDED).withEndTime(executions.stream().filter(e -> e.getUtcEnd() != null).map(e -> e.getUtcEnd().toInstant()).max(Comparator.comparing(Instant::toEpochMilli)).orElseThrow(NoSuchElementException::new)).addMeasurement(Measurement.measurement("queries_successful", "NONE", executions.stream().filter(QueryExecutionResult::isSuccessful).count())).addMeasurement(Measurement.measurement("queries_failed", "NONE", executions.stream().filter(query -> !query.isSuccessful()).count())).addAttribute("queries_order", executions.stream().map(QueryExecutionResult::getQueryName).collect(Collectors.joining(","))).build();
            this.benchmarkServiceClient.finishExecution(((QueryExecutionResult)executions.stream().findFirst().orElseThrow(NoSuchElementException::new)).getBenchmark().getUniqueName(), ((QueryExecutionResult)executions.stream().findFirst().orElseThrow(NoSuchElementException::new)).getBenchmark().getSequenceId(), this.executionSequenceId(((QueryExecutionResult)executions.stream().findFirst().orElseThrow(NoSuchElementException::new)).getQueryExecution()), finishRequest);
        });
    }

    private BenchmarkServiceClient.FinishRequest buildExecutionFinishedRequest(QueryExecutionResult executionResult, MeasurementsWithQueryInfo measurementsWithQueryInfo) {
        BenchmarkServiceClient.FinishRequest.FinishRequestBuilder requestBuilder = new BenchmarkServiceClient.FinishRequest.FinishRequestBuilder().withStatus(executionResult.isSuccessful() ? BenchmarkServiceClient.FinishRequest.Status.ENDED : BenchmarkServiceClient.FinishRequest.Status.FAILED).withEndTime(executionResult.getUtcEnd().toInstant()).addMeasurements(measurementsWithQueryInfo.getMeasurements());
        measurementsWithQueryInfo.getQueryInfo().ifPresent(requestBuilder::addQueryInfo);
        if (executionResult.getPrestoQueryId().isPresent()) {
            requestBuilder.addAttribute("prestoQueryId", executionResult.getPrestoQueryId().get());
        }
        if (!executionResult.isSuccessful()) {
            requestBuilder.addAttribute("failureMessage", executionResult.getFailureCause().getMessage());
            requestBuilder.addAttribute("failureStackTrace", ExceptionUtils.stackTraceToString(executionResult));
            if (executionResult.getFailureCause() instanceof SQLException) {
                requestBuilder.addAttribute("failureSQLErrorCode", "" + ((SQLException)executionResult.getFailureCause()).getErrorCode());
            }
        }
        return (BenchmarkServiceClient.FinishRequest)requestBuilder.build();
    }

    private CompletableFuture<MeasurementsWithQueryInfo> getMeasurementsWithQueryInfo(Measurable measurable) {
        CompletableFuture<List<Measurement>> measurementsFuture = this.getMeasurements(measurable);
        CompletableFuture<Optional<String>> queryInfoFuture = this.getQueryInfo(measurable);
        return measurementsFuture.thenCombine(queryInfoFuture, MeasurementsWithQueryInfo::new);
    }

    private CompletableFuture<List<Measurement>> getMeasurements(Measurable measurable) {
        ArrayList<CompletionStage> providerFutures = new ArrayList<CompletionStage>();
        List measurementsList = Collections.synchronizedList(new ArrayList());
        for (PostExecutionMeasurementProvider measurementProvider : this.measurementProviders) {
            CompletionStage future = measurementProvider.loadMeasurements(measurable).thenAccept(measurementsList::addAll);
            providerFutures.add(future);
        }
        return CompletableFuture.allOf(providerFutures.toArray(new CompletableFuture[0])).thenApply(aVoid -> ImmutableList.copyOf((Collection)measurementsList));
    }

    private CompletableFuture<Optional<String>> getQueryInfo(Measurable measurable) {
        if (this.queryInfoProvider == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return this.queryInfoProvider.loadQueryInfo(measurable);
    }

    private String executionSequenceId(QueryExecution execution) {
        return Integer.toString(execution.getSequenceId());
    }

    private static class MeasurementsWithQueryInfo {
        private final List<Measurement> measurements;
        private final Optional<String> queryInfo;

        private MeasurementsWithQueryInfo(List<Measurement> measurements, Optional<String> queryInfo) {
            this.measurements = Objects.requireNonNull(measurements, "measurements is null");
            this.queryInfo = Objects.requireNonNull(queryInfo, "queryInfo is null");
        }

        public List<Measurement> getMeasurements() {
            return this.measurements;
        }

        public Optional<String> getQueryInfo() {
            return this.queryInfo;
        }
    }
}

