/*
 * Decompiled with CFR 0.152.
 */
package io.trino.benchto.driver;

import com.google.common.base.Preconditions;
import io.trino.benchto.driver.BenchmarkExecutionException;
import io.trino.benchto.driver.execution.BenchmarkExecutionResult;
import java.util.List;
import java.util.NoSuchElementException;

public class FailedBenchmarkExecutionException
extends BenchmarkExecutionException {
    private final List<BenchmarkExecutionResult> failedBenchmarkResults;
    private final int benchmarksCount;

    public FailedBenchmarkExecutionException(List<BenchmarkExecutionResult> failedBenchmarkResults, int benchmarksCount) {
        super(FailedBenchmarkExecutionException.createMessage(failedBenchmarkResults));
        this.failedBenchmarkResults = failedBenchmarkResults;
        this.benchmarksCount = benchmarksCount;
        failedBenchmarkResults.stream().flatMap(benchmarkExecutionResult -> benchmarkExecutionResult.getFailureCauses().stream()).forEach(this::addSuppressed);
    }

    private static String createMessage(List<BenchmarkExecutionResult> failedBenchmarkResults) {
        Preconditions.checkArgument((!failedBenchmarkResults.isEmpty() ? 1 : 0) != 0, (Object)"no failures");
        return String.format("%s benchmarks failed, first failure was: %s", failedBenchmarkResults.size(), failedBenchmarkResults.get(0).getFailureCauses().stream().findFirst().map(e -> e.getMessage() + (String)(e.getCause() != null ? " (" + e.getCause().getMessage() + ")" : "")).orElseThrow(NoSuchElementException::new));
    }

    public List<BenchmarkExecutionResult> getFailedBenchmarkResults() {
        return this.failedBenchmarkResults;
    }

    public int getBenchmarksCount() {
        return this.benchmarksCount;
    }
}

