/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.maven.utils;

import java.util.Map;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transform.FileTransformerManager;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;

public final class RepositorySystemSessionWrapper
implements RepositorySystemSession {
    private RepositorySystemSession delegate;
    private DependencyGraphTransformer transformer;
    private boolean excludeSwarm;

    public RepositorySystemSessionWrapper(RepositorySystemSession delegate, boolean excludeSwarm) {
        this.delegate = delegate;
        this.transformer = new ConflictResolver((ConflictResolver.VersionSelector)new NearestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        this.excludeSwarm = excludeSwarm;
    }

    public boolean isOffline() {
        return this.delegate.isOffline();
    }

    public boolean isIgnoreArtifactDescriptorRepositories() {
        return this.delegate.isIgnoreArtifactDescriptorRepositories();
    }

    public ResolutionErrorPolicy getResolutionErrorPolicy() {
        return this.delegate.getResolutionErrorPolicy();
    }

    public ArtifactDescriptorPolicy getArtifactDescriptorPolicy() {
        return this.delegate.getArtifactDescriptorPolicy();
    }

    public String getChecksumPolicy() {
        return this.delegate.getChecksumPolicy();
    }

    public String getUpdatePolicy() {
        return this.delegate.getUpdatePolicy();
    }

    public LocalRepository getLocalRepository() {
        return this.delegate.getLocalRepository();
    }

    public LocalRepositoryManager getLocalRepositoryManager() {
        return this.delegate.getLocalRepositoryManager();
    }

    public WorkspaceReader getWorkspaceReader() {
        return this.delegate.getWorkspaceReader();
    }

    public RepositoryListener getRepositoryListener() {
        return this.delegate.getRepositoryListener();
    }

    public TransferListener getTransferListener() {
        return this.delegate.getTransferListener();
    }

    public Map<String, String> getSystemProperties() {
        return this.delegate.getSystemProperties();
    }

    public Map<String, String> getUserProperties() {
        return this.delegate.getUserProperties();
    }

    public Map<String, Object> getConfigProperties() {
        return this.delegate.getConfigProperties();
    }

    public MirrorSelector getMirrorSelector() {
        return this.delegate.getMirrorSelector();
    }

    public ProxySelector getProxySelector() {
        return this.delegate.getProxySelector();
    }

    public AuthenticationSelector getAuthenticationSelector() {
        return this.delegate.getAuthenticationSelector();
    }

    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.delegate.getArtifactTypeRegistry();
    }

    public DependencyTraverser getDependencyTraverser() {
        return this.excludeSwarm ? new SwarmExcludedTraverser() : this.delegate.getDependencyTraverser();
    }

    public DependencyManager getDependencyManager() {
        return this.delegate.getDependencyManager();
    }

    public DependencySelector getDependencySelector() {
        return this.delegate.getDependencySelector();
    }

    public VersionFilter getVersionFilter() {
        return this.delegate.getVersionFilter();
    }

    public DependencyGraphTransformer getDependencyGraphTransformer() {
        return this.transformer;
    }

    public SessionData getData() {
        return this.delegate.getData();
    }

    public RepositoryCache getCache() {
        return this.delegate.getCache();
    }

    public FileTransformerManager getFileTransformerManager() {
        return this.delegate.getFileTransformerManager();
    }

    public class SwarmExcludedTraverser
    implements DependencyTraverser {
        public boolean traverseDependency(Dependency dependency) {
            return !"io.thorntail".equals(dependency.getArtifact().getGroupId());
        }

        public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
            return this;
        }
    }
}

