/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.internal.worker.ScalingTask;
import io.temporal.workflow.Functions;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PollScaleReportHandle<T extends ScalingTask>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PollScaleReportHandle.class);
    private final int minPollerCount;
    private final int maxPollerCount;
    private int targetPollerCount;
    private final Functions.Proc1<Integer> scaleCallback;
    private boolean everSawScalingDecision;
    private int ingestedThisPeriod;
    private int ingestedLastPeriod;
    private boolean scaleUpAllowed;

    public PollScaleReportHandle(int minPollerCount, int maxPollerCount, int initialPollerCount, Functions.Proc1<Integer> scaleCallback) {
        this.minPollerCount = minPollerCount;
        this.maxPollerCount = maxPollerCount;
        this.targetPollerCount = initialPollerCount;
        this.scaleCallback = scaleCallback;
    }

    public synchronized void report(T task, Throwable e) {
        if (e != null) {
            StatusRuntimeException statusRuntimeException;
            if (e instanceof StatusRuntimeException && (statusRuntimeException = (StatusRuntimeException)e).getStatus().getCode() == Status.Code.RESOURCE_EXHAUSTED) {
                this.updateTarget(t -> t / 2);
                return;
            }
            this.updateTarget(t -> t - 1);
            return;
        }
        if (task != null) {
            ++this.ingestedThisPeriod;
        }
        if (task != null && task.getScalingDecision() != null) {
            ScalingTask.ScalingDecision scalingDecision = task.getScalingDecision();
            this.everSawScalingDecision = true;
            int deltaSuggestion = scalingDecision.getPollRequestDeltaSuggestion();
            if (deltaSuggestion > 0) {
                if (this.scaleUpAllowed) {
                    this.updateTarget(t -> t + deltaSuggestion);
                }
            } else if (deltaSuggestion < 0) {
                this.updateTarget(t -> t + deltaSuggestion);
            }
        } else if (task == null && this.everSawScalingDecision) {
            this.updateTarget(t -> t - 1);
        }
    }

    private void updateTarget(Functions.Func1<Integer, Integer> func) {
        Integer target = this.targetPollerCount;
        Integer newTarget = func.apply(target);
        if (newTarget < this.minPollerCount) {
            newTarget = this.minPollerCount;
        } else if (newTarget > this.maxPollerCount) {
            newTarget = this.maxPollerCount;
        }
        if (newTarget.equals(target)) {
            return;
        }
        this.targetPollerCount = newTarget;
        if (this.scaleCallback != null) {
            this.scaleCallback.apply(this.targetPollerCount);
        }
    }

    @Override
    public synchronized void run() {
        this.scaleUpAllowed = (double)this.ingestedThisPeriod >= (double)this.ingestedLastPeriod * 1.1;
        this.ingestedLastPeriod = this.ingestedThisPeriod;
        this.ingestedThisPeriod = 0;
    }
}

