/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.sdk.v1.WorkflowInteractionDefinition;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.workflow.DynamicQueryHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryDispatcher {
    private static final Logger log = LoggerFactory.getLogger(QueryDispatcher.class);
    private final DataConverter dataConverterWithWorkflowContext;
    private final Map<String, WorkflowOutboundCallsInterceptor.RegisterQueryInput> queryCallbacks = new HashMap<String, WorkflowOutboundCallsInterceptor.RegisterQueryInput>();
    private DynamicQueryHandler dynamicQueryHandler;
    private WorkflowInboundCallsInterceptor inboundCallsInterceptor;
    private static final ThreadLocal<SyncWorkflowContext> queryHandlerWorkflowContext = new ThreadLocal();

    public QueryDispatcher(DataConverter dataConverterWithWorkflowContext) {
        this.dataConverterWithWorkflowContext = dataConverterWithWorkflowContext;
    }

    public static boolean isQueryHandler() {
        SyncWorkflowContext value = queryHandlerWorkflowContext.get();
        return value != null;
    }

    public static SyncWorkflowContext getWorkflowContext() {
        SyncWorkflowContext value = queryHandlerWorkflowContext.get();
        if (value == null) {
            throw new IllegalStateException("Not in a query handler");
        }
        return value;
    }

    public void setInboundCallsInterceptor(WorkflowInboundCallsInterceptor inboundCallsInterceptor) {
        this.inboundCallsInterceptor = inboundCallsInterceptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WorkflowInboundCallsInterceptor.QueryOutput handleInterceptedQuery(WorkflowInboundCallsInterceptor.QueryInput input) {
        Object result;
        String queryName = input.getQueryName();
        Object[] args = input.getArguments();
        WorkflowOutboundCallsInterceptor.RegisterQueryInput handler = this.queryCallbacks.get(queryName);
        if (handler == null) {
            if (this.dynamicQueryHandler == null) throw new IllegalStateException("Unknown query type: " + queryName);
            result = this.dynamicQueryHandler.handle(queryName, (EncodedValues)args[0]);
            return new WorkflowInboundCallsInterceptor.QueryOutput(result);
        } else {
            result = handler.getCallback().apply(args);
        }
        return new WorkflowInboundCallsInterceptor.QueryOutput(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Payloads> handleQuery(SyncWorkflowContext replayContext, String queryName, Header header, Optional<Payloads> input) {
        Object[] args;
        WorkflowOutboundCallsInterceptor.RegisterQueryInput handler = this.queryCallbacks.get(queryName);
        if (queryName.startsWith(InternalUtils.TEMPORAL_RESERVED_PREFIX)) {
            throw new IllegalArgumentException("Unknown query type: " + queryName + ", knownTypes=" + this.queryCallbacks.keySet());
        }
        if (handler == null) {
            if (this.dynamicQueryHandler == null) {
                throw new IllegalArgumentException("Unknown query type: " + queryName + ", knownTypes=" + this.queryCallbacks.keySet());
            }
            args = new Object[]{new EncodedValues(input, this.dataConverterWithWorkflowContext)};
        } else {
            args = this.dataConverterWithWorkflowContext.fromPayloads(input, handler.getArgTypes(), handler.getGenericArgTypes());
        }
        try {
            replayContext.setReadOnly(true);
            queryHandlerWorkflowContext.set(replayContext);
            Object result = this.inboundCallsInterceptor.handleQuery(new WorkflowInboundCallsInterceptor.QueryInput(queryName, header, args)).getResult();
            Optional<Payloads> optional = this.dataConverterWithWorkflowContext.toPayloads(result);
            return optional;
        }
        finally {
            replayContext.setReadOnly(false);
            queryHandlerWorkflowContext.set(null);
        }
    }

    public void registerQueryHandlers(WorkflowOutboundCallsInterceptor.RegisterQueryInput request) {
        String queryType = request.getQueryType();
        if (this.queryCallbacks.containsKey(queryType)) {
            throw new IllegalStateException("Query \"" + queryType + "\" is already registered");
        }
        this.queryCallbacks.put(queryType, request);
    }

    public void registerDynamicQueryHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput input) {
        this.dynamicQueryHandler = input.getHandler();
    }

    public List<WorkflowInteractionDefinition> getQueryHandlers() {
        ArrayList<WorkflowInteractionDefinition> handlers = new ArrayList<WorkflowInteractionDefinition>(this.queryCallbacks.size() + 1);
        for (Map.Entry<String, WorkflowOutboundCallsInterceptor.RegisterQueryInput> entry : this.queryCallbacks.entrySet()) {
            WorkflowOutboundCallsInterceptor.RegisterQueryInput handler = entry.getValue();
            handlers.add(WorkflowInteractionDefinition.newBuilder().setName(handler.getQueryType()).setDescription(handler.getDescription()).build());
        }
        if (this.dynamicQueryHandler != null) {
            handlers.add(WorkflowInteractionDefinition.newBuilder().setDescription(this.dynamicQueryHandler.getDescription()).build());
        }
        handlers.sort(Comparator.comparing(WorkflowInteractionDefinition::getName));
        return handlers;
    }
}

